/*
 * Decompiled with CFR 0.152.
 */
package run.halo.seo.tools.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class OpenGraph {
    private String title;
    private String description;
    private String image;
    private AdditionalAttributes additionalMetaAttributes;

    public Map<String, List<String>> toMetaAttributes() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            hashMap.put("og:title", List.of(this.title));
        }
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            hashMap.put("og:description", List.of(this.description));
        }
        if (StringUtils.isNotBlank((CharSequence)this.image)) {
            hashMap.put("og:image", List.of(this.image));
        }
        hashMap.put("og:type", List.of("website"));
        if (this.additionalMetaAttributes != null) {
            hashMap.putAll(this.additionalMetaAttributes);
        }
        return hashMap;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImage() {
        return this.image;
    }

    public AdditionalAttributes getAdditionalMetaAttributes() {
        return this.additionalMetaAttributes;
    }

    public OpenGraph setTitle(String string) {
        this.title = string;
        return this;
    }

    public OpenGraph setDescription(String string) {
        this.description = string;
        return this;
    }

    public OpenGraph setImage(String string) {
        this.image = string;
        return this;
    }

    public OpenGraph setAdditionalMetaAttributes(AdditionalAttributes additionalAttributes) {
        this.additionalMetaAttributes = additionalAttributes;
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OpenGraph)) {
            return false;
        }
        OpenGraph openGraph = (OpenGraph)object;
        if (!openGraph.canEqual(this)) {
            return false;
        }
        String string = this.getTitle();
        String string2 = openGraph.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getDescription();
        String string4 = openGraph.getDescription();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getImage();
        String string6 = openGraph.getImage();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        AdditionalAttributes additionalAttributes = this.getAdditionalMetaAttributes();
        AdditionalAttributes additionalAttributes2 = openGraph.getAdditionalMetaAttributes();
        return !(additionalAttributes == null ? additionalAttributes2 != null : !((Object)additionalAttributes).equals(additionalAttributes2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof OpenGraph;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        String string = this.getTitle();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getDescription();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getImage();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        AdditionalAttributes additionalAttributes = this.getAdditionalMetaAttributes();
        n2 = n2 * 59 + (additionalAttributes == null ? 43 : ((Object)additionalAttributes).hashCode());
        return n2;
    }

    public String toString() {
        return "OpenGraph(title=" + this.getTitle() + ", description=" + this.getDescription() + ", image=" + this.getImage() + ", additionalMetaAttributes=" + this.getAdditionalMetaAttributes() + ")";
    }

    public static class AdditionalAttributes
    extends HashMap<String, List<String>> {
        @Override
        public void put(String string, String string2) {
            if (StringUtils.isBlank((CharSequence)string2)) {
                return;
            }
            this.put(string, List.of(string2));
        }
    }
}

