/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jeasy.rules.annotation.Action;
import org.jeasy.rules.annotation.Condition;
import org.jeasy.rules.annotation.Fact;
import org.jeasy.rules.annotation.Priority;
import org.jeasy.rules.annotation.Rule;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.core.ActionMethodOrderBean;
import org.jeasy.rules.core.NoSuchFactException;
import org.jeasy.rules.core.RuleDefinitionValidator;
import org.jeasy.rules.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleProxy
implements InvocationHandler {
    private final Object target;
    private String name;
    private String description;
    private Integer priority;
    private Method[] methods;
    private Method conditionMethod;
    private Set<ActionMethodOrderBean> actionMethods;
    private Method compareToMethod;
    private Method toStringMethod;
    private Rule annotation;
    private static final RuleDefinitionValidator ruleDefinitionValidator = new RuleDefinitionValidator();
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleProxy.class);

    public static org.jeasy.rules.api.Rule asRule(Object object) {
        org.jeasy.rules.api.Rule rule;
        if (object instanceof org.jeasy.rules.api.Rule) {
            rule = (org.jeasy.rules.api.Rule)object;
        } else {
            ruleDefinitionValidator.validateRuleDefinition(object);
            rule = (org.jeasy.rules.api.Rule)Proxy.newProxyInstance(org.jeasy.rules.api.Rule.class.getClassLoader(), new Class[]{org.jeasy.rules.api.Rule.class, Comparable.class}, (InvocationHandler)new RuleProxy(object));
        }
        return rule;
    }

    private RuleProxy(Object object) {
        this.target = object;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string;
        switch (string = method.getName()) {
            case "getName": {
                return this.getRuleName();
            }
            case "getDescription": {
                return this.getRuleDescription();
            }
            case "getPriority": {
                return this.getRulePriority();
            }
            case "compareTo": {
                return this.compareToMethod(objectArray);
            }
            case "evaluate": {
                return this.evaluateMethod(objectArray);
            }
            case "execute": {
                return this.executeMethod(objectArray);
            }
            case "equals": {
                return this.equalsMethod(objectArray);
            }
            case "hashCode": {
                return this.hashCodeMethod();
            }
            case "toString": {
                return this.toStringMethod();
            }
        }
        return null;
    }

    private Object evaluateMethod(Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        Facts facts = (Facts)objectArray[0];
        Method method = this.getConditionMethod();
        try {
            List<Object> list = this.getActualParameters(method, facts);
            return method.invoke(this.target, list.toArray());
        }
        catch (NoSuchFactException noSuchFactException) {
            LOGGER.warn("Rule '{}' has been evaluated to false due to a declared but missing fact '{}' in {}", this.getTargetClass().getName(), noSuchFactException.getMissingFact(), facts);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warn("Types of injected facts in method '{}' in rule '{}' do not match parameters types", method.getName(), this.getTargetClass().getName(), illegalArgumentException);
            return false;
        }
    }

    private Object executeMethod(Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        Facts facts = (Facts)objectArray[0];
        for (ActionMethodOrderBean actionMethodOrderBean : this.getActionMethodBeans()) {
            Method method = actionMethodOrderBean.getMethod();
            List<Object> list = this.getActualParameters(method, facts);
            method.invoke(this.target, list.toArray());
        }
        return null;
    }

    private Object compareToMethod(Object[] objectArray) throws Exception {
        Method method = this.getCompareToMethod();
        Object object = objectArray[0];
        if (method != null && Proxy.isProxyClass(object.getClass())) {
            if (method.getParameters().length != 1) {
                throw new IllegalArgumentException("compareTo method must have a single argument");
            }
            RuleProxy ruleProxy = (RuleProxy)Proxy.getInvocationHandler(object);
            return method.invoke(this.target, ruleProxy.getTarget());
        }
        return this.compareTo((org.jeasy.rules.api.Rule)object);
    }

    private List<Object> getActualParameters(Method method, Facts facts) {
        Annotation[][] annotationArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Annotation[] annotationArray2 : annotationArray = method.getParameterAnnotations()) {
            if (annotationArray2.length == 1) {
                String string = ((Fact)annotationArray2[0]).value();
                Object t = facts.get(string);
                if (t == null && !facts.asMap().containsKey(string)) {
                    throw new NoSuchFactException(String.format("No fact named '%s' found in known facts: %n%s", string, facts), string);
                }
                arrayList.add(t);
                continue;
            }
            arrayList.add(facts);
        }
        return arrayList;
    }

    private boolean equalsMethod(Object[] objectArray) throws Exception {
        if (!(objectArray[0] instanceof org.jeasy.rules.api.Rule)) {
            return false;
        }
        org.jeasy.rules.api.Rule rule = (org.jeasy.rules.api.Rule)objectArray[0];
        int n = rule.getPriority();
        int n2 = this.getRulePriority();
        if (n2 != n) {
            return false;
        }
        String string = rule.getName();
        String string2 = this.getRuleName();
        if (!string2.equals(string)) {
            return false;
        }
        String string3 = rule.getDescription();
        String string4 = this.getRuleDescription();
        return Objects.equals(string4, string3);
    }

    private int hashCodeMethod() throws Exception {
        int n = this.getRuleName().hashCode();
        int n2 = this.getRulePriority();
        String string = this.getRuleDescription();
        n = 31 * n + (string != null ? string.hashCode() : 0);
        n = 31 * n + n2;
        return n;
    }

    private Method getToStringMethod() {
        if (this.toStringMethod == null) {
            Method[] methodArray;
            for (Method method : methodArray = this.getMethods()) {
                if (!"toString".equals(method.getName())) continue;
                this.toStringMethod = method;
                return this.toStringMethod;
            }
        }
        return this.toStringMethod;
    }

    private String toStringMethod() throws Exception {
        Method method = this.getToStringMethod();
        if (method != null) {
            return (String)method.invoke(this.target, new Object[0]);
        }
        return this.getRuleName();
    }

    private int compareTo(org.jeasy.rules.api.Rule rule) throws Exception {
        int n = rule.getPriority();
        int n2 = this.getRulePriority();
        if (n2 < n) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        String string = rule.getName();
        String string2 = this.getRuleName();
        return string2.compareTo(string);
    }

    private int getRulePriority() throws Exception {
        if (this.priority == null) {
            Method[] methodArray;
            int n = 0x7FFFFFFE;
            Rule rule = this.getRuleAnnotation();
            if (rule.priority() != 0x7FFFFFFE) {
                n = rule.priority();
            }
            for (Method method : methodArray = this.getMethods()) {
                if (!method.isAnnotationPresent(Priority.class)) continue;
                n = (Integer)method.invoke(this.target, new Object[0]);
                break;
            }
            this.priority = n;
        }
        return this.priority;
    }

    private Method getConditionMethod() {
        if (this.conditionMethod == null) {
            Method[] methodArray;
            for (Method method : methodArray = this.getMethods()) {
                if (!method.isAnnotationPresent(Condition.class)) continue;
                this.conditionMethod = method;
                return this.conditionMethod;
            }
        }
        return this.conditionMethod;
    }

    private Set<ActionMethodOrderBean> getActionMethodBeans() {
        if (this.actionMethods == null) {
            Method[] methodArray;
            this.actionMethods = new TreeSet<ActionMethodOrderBean>();
            for (Method method : methodArray = this.getMethods()) {
                if (!method.isAnnotationPresent(Action.class)) continue;
                Action action = method.getAnnotation(Action.class);
                int n = action.order();
                this.actionMethods.add(new ActionMethodOrderBean(method, n));
            }
        }
        return this.actionMethods;
    }

    private Method getCompareToMethod() {
        if (this.compareToMethod == null) {
            Method[] methodArray;
            for (Method method : methodArray = this.getMethods()) {
                if (!method.getName().equals("compareTo")) continue;
                this.compareToMethod = method;
                return this.compareToMethod;
            }
        }
        return this.compareToMethod;
    }

    private Method[] getMethods() {
        if (this.methods == null) {
            this.methods = this.getTargetClass().getMethods();
        }
        return this.methods;
    }

    private Rule getRuleAnnotation() {
        if (this.annotation == null) {
            this.annotation = Utils.findAnnotation(Rule.class, this.getTargetClass());
        }
        return this.annotation;
    }

    private String getRuleName() {
        if (this.name == null) {
            Rule rule = this.getRuleAnnotation();
            this.name = rule.name().equals("rule") ? this.getTargetClass().getSimpleName() : rule.name();
        }
        return this.name;
    }

    private String getRuleDescription() {
        if (this.description == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendConditionMethodName(stringBuilder);
            this.appendActionMethodsNames(stringBuilder);
            Rule rule = this.getRuleAnnotation();
            this.description = rule.description().equals("description") ? stringBuilder.toString() : rule.description();
        }
        return this.description;
    }

    private void appendConditionMethodName(StringBuilder stringBuilder) {
        Method method = this.getConditionMethod();
        if (method != null) {
            stringBuilder.append("when ");
            stringBuilder.append(method.getName());
            stringBuilder.append(" then ");
        }
    }

    private void appendActionMethodsNames(StringBuilder stringBuilder) {
        Iterator<ActionMethodOrderBean> iterator = this.getActionMethodBeans().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().getMethod().getName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
    }

    public Object getTarget() {
        return this.target;
    }

    private Class<?> getTargetClass() {
        return this.target.getClass();
    }
}

