/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.jeasy.rules.annotation.Action;
import org.jeasy.rules.annotation.Condition;
import org.jeasy.rules.annotation.Fact;
import org.jeasy.rules.annotation.Priority;
import org.jeasy.rules.annotation.Rule;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.core.Utils;

class RuleDefinitionValidator {
    RuleDefinitionValidator() {
    }

    void validateRuleDefinition(Object object) {
        this.checkRuleClass(object);
        this.checkConditionMethod(object);
        this.checkActionMethods(object);
        this.checkPriorityMethod(object);
    }

    private void checkRuleClass(Object object) {
        if (!this.isRuleClassWellDefined(object)) {
            throw new IllegalArgumentException(String.format("Rule '%s' is not annotated with '%s'", object.getClass().getName(), Rule.class.getName()));
        }
    }

    private void checkConditionMethod(Object object) {
        List<Method> list = this.getMethodsAnnotatedWith(Condition.class, object);
        if (list.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have a public method annotated with '%s'", object.getClass().getName(), Condition.class.getName()));
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have exactly one method annotated with '%s'", object.getClass().getName(), Condition.class.getName()));
        }
        Method method = list.get(0);
        if (!this.isConditionMethodWellDefined(method)) {
            throw new IllegalArgumentException(String.format("Condition method '%s' defined in rule '%s' must be public, must return boolean type and may have parameters annotated with @Fact (and/or exactly one parameter of type Facts or one of its sub-types).", method, object.getClass().getName()));
        }
    }

    private void checkActionMethods(Object object) {
        List<Method> list = this.getMethodsAnnotatedWith(Action.class, object);
        if (list.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have at least one public method annotated with '%s'", object.getClass().getName(), Action.class.getName()));
        }
        for (Method method : list) {
            if (this.isActionMethodWellDefined(method)) continue;
            throw new IllegalArgumentException(String.format("Action method '%s' defined in rule '%s' must be public, must return void type and may have parameters annotated with @Fact (and/or exactly one parameter of type Facts or one of its sub-types).", method, object.getClass().getName()));
        }
    }

    private void checkPriorityMethod(Object object) {
        List<Method> list = this.getMethodsAnnotatedWith(Priority.class, object);
        if (list.isEmpty()) {
            return;
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have exactly one method annotated with '%s'", object.getClass().getName(), Priority.class.getName()));
        }
        Method method = list.get(0);
        if (!this.isPriorityMethodWellDefined(method)) {
            throw new IllegalArgumentException(String.format("Priority method '%s' defined in rule '%s' must be public, have no parameters and return integer type.", method, object.getClass().getName()));
        }
    }

    private boolean isRuleClassWellDefined(Object object) {
        return Utils.isAnnotationPresent(Rule.class, object.getClass());
    }

    private boolean isConditionMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Boolean.TYPE) && this.validParameters(method);
    }

    private boolean validParameters(Method method) {
        int n = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        Object object = annotationArray;
        int n2 = ((Annotation[][])object).length;
        for (int i = 0; i < n2; ++i) {
            Annotation[] annotationArray2 = object[i];
            if (annotationArray2.length == 0) {
                ++n;
                continue;
            }
            for (Annotation annotation : annotationArray2) {
                if (annotation.annotationType().equals(Fact.class)) continue;
                return false;
            }
        }
        if (n > 1) {
            return false;
        }
        if (n == 1 && (object = this.getNotAnnotatedParameter(method)) != null) {
            return Facts.class.isAssignableFrom(((Parameter)object).getType());
        }
        return true;
    }

    private Parameter getNotAnnotatedParameter(Method method) {
        Parameter[] parameterArray;
        for (Parameter parameter : parameterArray = method.getParameters()) {
            if (parameter.getAnnotations().length != 0) continue;
            return parameter;
        }
        return null;
    }

    private boolean isActionMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Void.TYPE) && this.validParameters(method);
    }

    private boolean isPriorityMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Integer.TYPE) && method.getParameterTypes().length == 0;
    }

    private List<Method> getMethodsAnnotatedWith(Class<? extends Annotation> clazz, Object object) {
        Method[] methodArray = this.getMethods(object);
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : methodArray) {
            if (!method.isAnnotationPresent(clazz)) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    private Method[] getMethods(Object object) {
        return object.getClass().getMethods();
    }
}

