/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.util.HashMap;
import java.util.Map;
import org.jeasy.rules.api.Fact;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.api.RulesEngineParameters;
import org.jeasy.rules.core.AbstractRulesEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRulesEngine
extends AbstractRulesEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRulesEngine.class);

    public DefaultRulesEngine() {
    }

    public DefaultRulesEngine(RulesEngineParameters rulesEngineParameters) {
        super(rulesEngineParameters);
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        this.triggerListenersBeforeRules(rules, facts);
        this.doFire(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
    }

    void doFire(Rules rules, Facts facts) {
        if (rules.isEmpty()) {
            LOGGER.warn("No rules registered! Nothing to apply");
            return;
        }
        this.logEngineParameters();
        this.log(rules);
        this.log(facts);
        LOGGER.debug("Rules evaluation started");
        for (Rule rule : rules) {
            boolean bl;
            String string;
            block9: {
                string = rule.getName();
                int n = rule.getPriority();
                if (n > this.parameters.getPriorityThreshold()) {
                    LOGGER.debug("Rule priority threshold ({}) exceeded at rule '{}' with priority={}, next rules will be skipped", this.parameters.getPriorityThreshold(), string, n);
                    break;
                }
                if (!this.shouldBeEvaluated(rule, facts)) {
                    LOGGER.debug("Rule '{}' has been skipped before being evaluated", (Object)string);
                    continue;
                }
                bl = false;
                try {
                    bl = rule.evaluate(facts);
                }
                catch (RuntimeException runtimeException) {
                    LOGGER.error("Rule '" + string + "' evaluated with error", runtimeException);
                    this.triggerListenersOnEvaluationError(rule, facts, runtimeException);
                    if (!this.parameters.isSkipOnFirstNonTriggeredRule()) break block9;
                    LOGGER.debug("Next rules will be skipped since parameter skipOnFirstNonTriggeredRule is set");
                    break;
                }
            }
            if (bl) {
                LOGGER.debug("Rule '{}' triggered", (Object)string);
                this.triggerListenersAfterEvaluate(rule, facts, true);
                try {
                    this.triggerListenersBeforeExecute(rule, facts);
                    rule.execute(facts);
                    LOGGER.debug("Rule '{}' performed successfully", (Object)string);
                    this.triggerListenersOnSuccess(rule, facts);
                    if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                    LOGGER.debug("Next rules will be skipped since parameter skipOnFirstAppliedRule is set");
                }
                catch (Exception exception) {
                    LOGGER.error("Rule '" + string + "' performed with error", exception);
                    this.triggerListenersOnFailure(rule, exception, facts);
                    if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                    LOGGER.debug("Next rules will be skipped since parameter skipOnFirstFailedRule is set");
                }
                break;
            }
            LOGGER.debug("Rule '{}' has been evaluated to false, it has not been executed", (Object)string);
            this.triggerListenersAfterEvaluate(rule, facts, false);
            if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
            LOGGER.debug("Next rules will be skipped since parameter skipOnFirstNonTriggeredRule is set");
            break;
        }
    }

    private void logEngineParameters() {
        LOGGER.debug("{}", (Object)this.parameters);
    }

    private void log(Rules rules) {
        LOGGER.debug("Registered rules:");
        for (Rule rule : rules) {
            LOGGER.debug("Rule { name = '{}', description = '{}', priority = '{}'}", rule.getName(), rule.getDescription(), rule.getPriority());
        }
    }

    private void log(Facts facts) {
        LOGGER.debug("Known facts:");
        for (Fact<?> fact : facts) {
            LOGGER.debug("{}", (Object)fact);
        }
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) {
        this.triggerListenersBeforeRules(rules, facts);
        Map<Rule, Boolean> map = this.doCheck(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
        return map;
    }

    private Map<Rule, Boolean> doCheck(Rules rules, Facts facts) {
        LOGGER.debug("Checking rules");
        HashMap<Rule, Boolean> hashMap = new HashMap<Rule, Boolean>();
        for (Rule rule : rules) {
            if (!this.shouldBeEvaluated(rule, facts)) continue;
            hashMap.put(rule, rule.evaluate(facts));
        }
        return hashMap;
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onFailure(rule, facts, exception));
    }

    private void triggerListenersOnSuccess(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onSuccess(rule, facts));
    }

    private void triggerListenersBeforeExecute(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.beforeExecute(rule, facts));
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule, Facts facts) {
        return this.ruleListeners.stream().allMatch(ruleListener -> ruleListener.beforeEvaluate(rule, facts));
    }

    private void triggerListenersAfterEvaluate(Rule rule, Facts facts, boolean bl) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.afterEvaluate(rule, facts, bl));
    }

    private void triggerListenersOnEvaluationError(Rule rule, Facts facts, Exception exception) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onEvaluationError(rule, facts, exception));
    }

    private void triggerListenersBeforeRules(Rules rules, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.beforeEvaluate(rules, facts));
    }

    private void triggerListenersAfterRules(Rules rules, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.afterExecute(rules, facts));
    }

    private boolean shouldBeEvaluated(Rule rule, Facts facts) {
        return this.triggerListenersBeforeEvaluate(rule, facts);
    }
}

