/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.core.RuleProxy;

public class Rules
implements Iterable<Rule> {
    private Set<Rule> rules = new TreeSet<Rule>();

    public Rules(Set<Rule> set) {
        this.rules = new TreeSet<Rule>(set);
    }

    public Rules(Rule ... ruleArray) {
        Collections.addAll(this.rules, ruleArray);
    }

    public Rules(Object ... objectArray) {
        this.register(objectArray);
    }

    public void register(Object ... objectArray) {
        Objects.requireNonNull(objectArray);
        for (Object object : objectArray) {
            Objects.requireNonNull(object);
            this.rules.add(RuleProxy.asRule(object));
        }
    }

    public void unregister(Object ... objectArray) {
        Objects.requireNonNull(objectArray);
        for (Object object : objectArray) {
            Objects.requireNonNull(object);
            this.rules.remove(RuleProxy.asRule(object));
        }
    }

    public void unregister(String string) {
        Objects.requireNonNull(string);
        Rule rule = this.findRuleByName(string);
        if (rule != null) {
            this.unregister(rule);
        }
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public void clear() {
        this.rules.clear();
    }

    public int size() {
        return this.rules.size();
    }

    @Override
    public Iterator<Rule> iterator() {
        return this.rules.iterator();
    }

    private Rule findRuleByName(String string) {
        return this.rules.stream().filter(rule -> rule.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }
}

