/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jeasy.rules.api.Fact;

public class Facts
implements Iterable<Fact<?>> {
    private final Set<Fact<?>> facts = new HashSet();

    public <T> void put(String string, T t) {
        Objects.requireNonNull(string, "fact name must not be null");
        Objects.requireNonNull(t, "fact value must not be null");
        Fact<?> fact = this.getFact(string);
        if (fact != null) {
            this.remove(fact);
        }
        this.add(new Fact<T>(string, t));
    }

    public <T> void add(Fact<T> fact) {
        Objects.requireNonNull(fact, "fact must not be null");
        Fact<?> fact2 = this.getFact(fact.getName());
        if (fact2 != null) {
            this.remove(fact2);
        }
        this.facts.add(fact);
    }

    public void remove(String string) {
        Objects.requireNonNull(string, "fact name must not be null");
        Fact<?> fact = this.getFact(string);
        if (fact != null) {
            this.remove(fact);
        }
    }

    public <T> void remove(Fact<T> fact) {
        Objects.requireNonNull(fact, "fact must not be null");
        this.facts.remove(fact);
    }

    public <T> T get(String string) {
        Objects.requireNonNull(string, "fact name must not be null");
        Fact<?> fact = this.getFact(string);
        if (fact != null) {
            return (T)fact.getValue();
        }
        return null;
    }

    public Fact<?> getFact(String string) {
        Objects.requireNonNull(string, "fact name must not be null");
        return this.facts.stream().filter(fact -> fact.getName().equals(string)).findFirst().orElse(null);
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Fact<?> fact : this.facts) {
            hashMap.put(fact.getName(), fact.getValue());
        }
        return hashMap;
    }

    @Override
    public Iterator<Fact<?>> iterator() {
        return this.facts.iterator();
    }

    public void clear() {
        this.facts.clear();
    }

    public String toString() {
        Iterator<Fact<?>> iterator = this.facts.iterator();
        StringBuilder stringBuilder = new StringBuilder("[");
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

