/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.utils;

import java.security.Principal;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import reactor.core.publisher.Mono;
import run.halo.app.infra.AnonymousUserConst;
import run.halo.doc.utils.AuthorityUtils;

public class PrincipalUtils {
    public static Mono<String> currentUsername() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).map(Principal::getName).filter(name -> !AnonymousUserConst.isAnonymousUser((String)name));
    }

    public static Mono<Authentication> getAuthenticated() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication);
    }

    public static Set<String> convertToRoles(Authentication auth) {
        if (auth == null) {
            return Set.of();
        }
        return AuthorityUtils.authoritiesToRoles(auth.getAuthorities());
    }
}

