/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.utils;

import io.micrometer.common.util.StringUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public record NaryTreeWalker<T extends TreeNode<T>>(List<T> nodes) {
    public NaryTreeWalker {
        Assert.notNull(nodes, (String)"Nodes must not be null");
    }

    public static <T extends TreeNode<T>> NaryTreeWalker<T> of(List<T> nodes) {
        return new NaryTreeWalker<T>(NaryTreeWalker.listToTree(nodes));
    }

    public static <T extends TreeNode<T>> List<T> listToTree(List<T> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptyList();
        }
        ArrayList topNodes = new ArrayList();
        nodes.forEach(element -> {
            String parent = element.getParent();
            if (StringUtils.isBlank((String)parent)) {
                topNodes.add(element);
                return;
            }
            for (TreeNode n : nodes) {
                String name = n.getName();
                if (!StringUtils.isNotBlank((String)name) || !name.equals(parent)) continue;
                n.addChild(element);
                return;
            }
            if (topNodes.isEmpty()) {
                topNodes.add(element);
            }
        });
        return topNodes;
    }

    public static <T extends TreeNode<T>> List<T> treeToList(List<T> treeNodes) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return List.of();
        }
        ArrayList list = new ArrayList();
        NaryTreeWalker.bfs(treeNodes, list::add);
        return list;
    }

    static <T extends TreeNode<T>> void bfs(List<T> treeNodes, Consumer<T> nodeConsumer) {
        if (treeNodes == null) {
            return;
        }
        ArrayDeque<T> queue = new ArrayDeque<T>(treeNodes);
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.poll();
            nodeConsumer.accept(node);
            queue.addAll(node.getChildren());
        }
    }

    public static <T extends TreeNode<T>> List<T> dfs(List<T> treeNodes) {
        ArrayList result = new ArrayList();
        NaryTreeWalker.dfs(treeNodes, result);
        return result;
    }

    private static <T extends TreeNode<T>> void dfs(List<T> nodes, List<T> result) {
        if (nodes == null) {
            return;
        }
        for (TreeNode node : nodes) {
            result.add(node);
            NaryTreeWalker.dfs(node.getChildren(), result);
        }
    }

    public List<T> treeToList() {
        return NaryTreeWalker.treeToList(this.nodes);
    }

    public List<T> findChildren(String name) {
        ArrayList result = new ArrayList();
        ArrayDeque<T> queue = new ArrayDeque<T>(this.nodes);
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.poll();
            if (node.getName().equals(name)) {
                result.addAll(node.getChildren());
                return result;
            }
            queue.addAll(node.getChildren());
        }
        return result;
    }

    public List<String> computeNodePath(String nodeToFind) {
        Assert.notNull((Object)nodeToFind, (String)"Node name to find must not be null");
        ArrayList<String> nodePath = new ArrayList<String>();
        TreeNode<TreeNode> virtualRoot = new TreeNode<TreeNode>();
        for (TreeNode node : this.nodes) {
            virtualRoot.addChild(node);
        }
        this.findPath(virtualRoot, nodeToFind, nodePath);
        return nodePath;
    }

    public List<T> computeNodePath(T nodeToFind) {
        Assert.notNull(nodeToFind, (String)"Node to find must not be null");
        ArrayList<TreeNode<T>> nodePath = new ArrayList<TreeNode<T>>();
        TreeNode<TreeNode> virtualRoot = new TreeNode<TreeNode>();
        for (TreeNode node2 : this.nodes) {
            virtualRoot.addChild(node2);
        }
        this.findPath((TreeNode<T>)virtualRoot, (TreeNode<T>)nodeToFind, (List<TreeNode<T>>)nodePath);
        return nodePath.stream().map(node -> node).collect(Collectors.toList());
    }

    List<TreeNode<T>> findPath(TreeNode<T> node, TreeNode<T> targetNode, List<TreeNode<T>> currPath) {
        if (targetNode.getName().equals(node.getName())) {
            currPath.add(targetNode);
            return currPath;
        }
        for (TreeNode child : node.children) {
            List<TreeNode<T>> path = this.findPath(child, targetNode, currPath);
            if (path == null || node.getName() == null) continue;
            path.add(0, node);
            return path;
        }
        return null;
    }

    List<String> findPath(TreeNode<T> node, String targetName, List<String> currPath) {
        if (targetName.equals(node.getName())) {
            currPath.add(targetName);
            return currPath;
        }
        for (TreeNode child : node.children) {
            List<String> path = this.findPath(child, targetName, currPath);
            if (path == null || node.getName() == null) continue;
            path.add(0, node.getName());
            return path;
        }
        return null;
    }

    public List<T> sortBy(Comparator<T> comparator) {
        NaryTreeWalker.bfs(this.nodes, node -> node.getChildren().sort(comparator));
        this.nodes.sort(comparator);
        return this.nodes;
    }

    public static class TreeNode<T extends TreeNode<T>> {
        protected final List<T> children = new ArrayList<T>();
        private String name;
        private String parent;

        public TreeNode(String name, String parent) {
            this.name = name;
            this.parent = parent;
        }

        void addChild(T child) {
            this.children.add(child);
        }

        @Generated
        public List<T> getChildren() {
            return this.children;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getParent() {
            return this.parent;
        }

        @Generated
        public TreeNode() {
        }
    }
}

