/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import run.halo.app.infra.utils.JsonUtils;
import run.halo.doc.extensions.DocTree;

public final class DocTreeUtils {
    public static final String ROUTE_PATTERN = "/docs/{projectSlug}/{versionSlug}/{docTreePath}";

    public static List<DocTree> copyDocTreeList(String newVersionName, List<DocTree> originalList) {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        ArrayList<DocTree> copiedList = new ArrayList<DocTree>();
        for (DocTree node : originalList) {
            String newName = DocTreeUtils.generateNewName();
            nameMapping.put(node.getMetadata().getName(), newName);
        }
        for (DocTree originalNode : originalList) {
            String newParentName = (String)nameMapping.get(originalNode.getSpec().getParent());
            String newName = (String)nameMapping.get(originalNode.getMetadata().getName());
            DocTree newNode = (DocTree)((Object)JsonUtils.deepCopy((Object)((Object)originalNode)));
            newNode.getMetadata().setName(newName);
            newNode.getSpec().setProjectVersionName(newVersionName);
            newNode.getSpec().setParent(newParentName);
            newNode.setStatus(null);
            copiedList.add(newNode);
        }
        return copiedList;
    }

    public static String buildRoutePathWithGivenVariables(Map<String, String> pathVariables) {
        int end;
        int start;
        int pos = 0;
        Object pattern = ROUTE_PATTERN;
        while (pos < ((String)pattern).length() && (start = ((String)pattern).indexOf(123, pos)) != -1 && (end = ((String)pattern).indexOf(125, start)) != -1) {
            String name = ((String)pattern).substring(start + 1, end);
            String value = pathVariables.get(name);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                pattern = ((String)pattern).substring(0, start) + value + ((String)pattern).substring(end + 1);
                pos = start + value.length();
                continue;
            }
            pattern = ((String)pattern).substring(0, start - 1) + ((String)pattern).substring(end + 1);
        }
        return pattern;
    }

    private static String generateNewName() {
        return UUID.randomUUID().toString();
    }

    @Generated
    private DocTreeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

