/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.utils;

import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import run.halo.doc.model.DocTreeNode;

public final class DocTreeNodeUtils {
    public static Comparator<DocTreeNode> treeNodeComparator() {
        Function<DocTreeNode, Integer> priorityFunc = docTree -> (Integer)ObjectUtils.defaultIfNull((Object)docTree.getSpec().getPriority(), (Object)0);
        Function<DocTreeNode, String> nameFunc = docTree -> docTree.getMetadata().getName();
        Function<DocTreeNode, Instant> creationTimeFunc = docTree -> docTree.getMetadata().getCreationTimestamp();
        return Comparator.comparing(priorityFunc).thenComparing(nameFunc).thenComparing(creationTimeFunc);
    }

    public static Map<String, DocTreeNode> getNameLanguageNodeMap(List<DocTreeNode> docTreeList) {
        return DocTreeNodeUtils.getNameLanguageNodeMap(docTreeList, docTreeNode -> docTreeNode.getMetadata().getName());
    }

    public static Map<String, DocTreeNode> getSlugLanguageNodeMap(List<DocTreeNode> docTreeList) {
        return DocTreeNodeUtils.getNameLanguageNodeMap(docTreeList, docTreeNode -> docTreeNode.getSpec().getSlug());
    }

    static Map<String, DocTreeNode> getNameLanguageNodeMap(List<DocTreeNode> docTreeList, Function<DocTreeNode, String> mapKeyFunc) {
        if (docTreeList == null) {
            return Map.of();
        }
        return docTreeList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getSpec().getParent())).filter(item -> {
            Map labels = item.getMetadata().getLabels();
            if (labels == null) {
                return false;
            }
            String markedAsLang = (String)labels.get("doc.halo.run/marked-as-language");
            return "true".equals(markedAsLang);
        }).collect(Collectors.toMap(mapKeyFunc, item -> item, (existing, replacement) -> replacement));
    }

    @Generated
    private DocTreeNodeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

