/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.theme;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.context.annotation.Bean;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;
import run.halo.app.extension.ListOptions;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.plugin.PluginContext;
import run.halo.app.theme.TemplateNameResolver;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.infra.NotFoundException;
import run.halo.doc.service.DocTreeService;
import run.halo.doc.service.ProjectGetter;
import run.halo.doc.service.ProjectPermissionService;
import run.halo.doc.service.ProjectVersionLister;
import run.halo.doc.theme.DocTreeRequestHandler;

@Component
public class ProjectRouterFunction {
    private final ProjectGetter projectGetter;
    private final ProjectVersionLister projectVersionLister;
    private final DocTreeRequestHandler docTreeRequestHandler;
    private final ReactiveExtensionClient client;
    private final TemplateNameResolver templateNameResolver;
    private final PluginContext pluginContext;
    private final ProjectPermissionService projectPermissionService;
    private final DocTreeService docTreeService;

    @Bean
    public RouterFunction<ServerResponse> projectRouterFunction() {
        return RouterFunctions.route().nest(RequestPredicates.path((String)"/docs"), builder -> builder.GET(RequestPredicates.path((String)"").or(RequestPredicates.path((String)"/")), this::listAllProject).GET("/{projectSlug}", this::projectHandler).GET("/{projectSlug}/{versionSlug}", this::projectVersionHandler).GET("/{projectSlug}/{versionSlug}/{lang}", this::projectVersionLangHandler)).build();
    }

    private Mono<ServerResponse> listAllProject(ServerRequest request) {
        return this.client.listAll(Project.class, new ListOptions(), Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"metadata.creationTimestamp"), Sort.Order.desc((String)"metadata.name")})).filterWhen(project -> {
            if (project.getSpec().isAuthorizeRequired()) {
                return this.projectPermissionService.hasPermission((Project)((Object)project), Project.PermissionLevel.READ);
            }
            return Mono.just((Object)true);
        }).collectList().flatMap(projects -> this.renderDocs(request, (List<Project>)projects));
    }

    private Mono<ServerResponse> renderDocs(ServerRequest request, List<Project> projects) {
        return this.templateNameResolver.resolveTemplateNameOrDefault(request.exchange(), "docs").flatMap(templateName -> ServerResponse.ok().render(templateName, Map.of("projects", projects, "plugin", Map.of("name", this.pluginContext.getName(), "version", this.pluginContext.getVersion()))));
    }

    private Mono<ServerResponse> projectVersionLangHandler(ServerRequest request) {
        String projectSlug = request.pathVariable("projectSlug");
        String versionSlug = request.pathVariable("versionSlug");
        String lang = request.pathVariable("lang");
        return this.projectGetter.getBySlug(projectSlug).flatMap(this::checkReadPermission).flatMap(project -> {
            String projectName = project.getMetadata().getName();
            return this.projectVersionLister.getByProjectNameAndVersionSlug(projectName, versionSlug).filter(ProjectVersion::isPublished).next();
        }).flatMap(version -> {
            String versionName = version.getMetadata().getName();
            return this.docTreeService.getFirstDocTree(versionName, lang);
        }).switchIfEmpty(Mono.error((Throwable)((Object)new NotFoundException("No doc resource found.")))).flatMap(docTree -> this.docTreeRequestHandler.handle(request, docTree.getMetadata().getName()));
    }

    private Mono<ServerResponse> projectVersionHandler(ServerRequest request) {
        String projectSlug = request.pathVariable("projectSlug");
        String versionSlug = request.pathVariable("versionSlug");
        return this.projectGetter.getBySlug(projectSlug).flatMap(this::checkReadPermission).flatMap(project -> {
            String lang = project.getSpec().getPreferredLanguage();
            String projectName = project.getMetadata().getName();
            return this.projectVersionLister.getByProjectNameAndVersionSlug(projectName, versionSlug).filter(ProjectVersion::isPublished).next().flatMap(projectVersion -> {
                String versionName = projectVersion.getMetadata().getName();
                return this.docTreeService.getFirstDocTree(versionName, lang);
            });
        }).switchIfEmpty(Mono.error((Throwable)((Object)new NotFoundException("No doc resource found.")))).flatMap(docTree -> this.docTreeRequestHandler.handle(request, docTree.getMetadata().getName()));
    }

    private Mono<ServerResponse> projectHandler(ServerRequest request) {
        String projectSlug = request.pathVariable("projectSlug");
        return this.projectGetter.getBySlug(projectSlug).flatMap(this::checkReadPermission).flatMap(project -> {
            String lang = project.getSpec().getPreferredLanguage();
            Project.VersionRef versionRef = project.getSpec().getPreferredVersionRef();
            if (versionRef == null) {
                return Mono.error(() -> new ServerWebInputException("No preferred version found"));
            }
            return this.docTreeService.getFirstDocTree(versionRef.getName(), lang);
        }).switchIfEmpty(Mono.error((Throwable)((Object)new NotFoundException("No doc resource found.")))).flatMap(docTree -> this.docTreeRequestHandler.handle(request, docTree.getMetadata().getName()));
    }

    Mono<Project> checkReadPermission(Project project) {
        if (project.getSpec().isAuthorizeRequired()) {
            return this.projectPermissionService.checkPermission(project, Project.PermissionLevel.READ).thenReturn((Object)project);
        }
        return Mono.just((Object)((Object)project));
    }

    @Generated
    public ProjectRouterFunction(ProjectGetter projectGetter, ProjectVersionLister projectVersionLister, DocTreeRequestHandler docTreeRequestHandler, ReactiveExtensionClient client, TemplateNameResolver templateNameResolver, PluginContext pluginContext, ProjectPermissionService projectPermissionService, DocTreeService docTreeService) {
        this.projectGetter = projectGetter;
        this.projectVersionLister = projectVersionLister;
        this.docTreeRequestHandler = docTreeRequestHandler;
        this.client = client;
        this.templateNameResolver = templateNameResolver;
        this.pluginContext = pluginContext;
        this.projectPermissionService = projectPermissionService;
        this.docTreeService = docTreeService;
    }
}

