/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.theme;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;
import run.halo.app.infra.utils.JsonUtils;
import run.halo.app.plugin.PluginContext;
import run.halo.app.theme.TemplateNameResolver;
import run.halo.app.theme.dialect.CommentWidget;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.Project;
import run.halo.doc.model.DocTreeDetail;
import run.halo.doc.service.DocTreeService;
import run.halo.doc.service.ProjectPermissionService;

@Component
public class DocTreeRequestHandler {
    private final DocTreeService docTreeService;
    private final TemplateNameResolver templateNameResolver;
    private final PluginContext pluginContext;
    private final ProjectPermissionService projectPermissionService;

    public Mono<ServerResponse> handle(ServerRequest request, String docTreeName) {
        return this.docTreeService.getByName(docTreeName, true).flatMap(this::checkReadPermission).flatMap(docTreeDetail -> {
            Map<String, Object> model = this.convertToModel((DocTreeDetail)docTreeDetail);
            if (DocTree.isDoc(docTreeDetail.getDocTree())) {
                return this.templateNameResolver.resolveTemplateNameOrDefault(request.exchange(), "doc").flatMap(templateName -> ServerResponse.ok().render(templateName, model));
            }
            return this.templateNameResolver.resolveTemplateNameOrDefault(request.exchange(), "doc-catalog").flatMap(templateName -> ServerResponse.ok().render(templateName, model));
        }).switchIfEmpty(Mono.defer(() -> ServerResponse.notFound().build()));
    }

    Map<String, Object> convertToModel(DocTreeDetail docTreeDetail) {
        Map docDetailModel = (Map)JsonUtils.mapper().convertValue((Object)docTreeDetail, (TypeReference)new TypeReference<Map<String, Object>>(){});
        HashMap<String, Object> model = new HashMap<String, Object>(docDetailModel);
        model.put("plugin", Map.of("name", this.pluginContext.getName(), "version", this.pluginContext.getVersion()));
        boolean enableComment = docTreeDetail.getProject().getSpec().isEnableComment();
        model.put(CommentWidget.ENABLE_COMMENT_ATTRIBUTE, enableComment);
        Project project = docTreeDetail.getProject();
        Mono<Boolean> hasWritePermission = this.projectPermissionService.hasPermission(project, Project.PermissionLevel.WRITE);
        model.put("canEdit", hasWritePermission);
        return model;
    }

    Mono<DocTreeDetail> checkReadPermission(DocTreeDetail docTreeDetail) {
        if (docTreeDetail.getProject().getSpec().isAuthorizeRequired()) {
            return this.projectPermissionService.checkPermission(docTreeDetail.getProject(), Project.PermissionLevel.READ).thenReturn((Object)docTreeDetail);
        }
        return Mono.just((Object)docTreeDetail);
    }

    @Generated
    public DocTreeRequestHandler(DocTreeService docTreeService, TemplateNameResolver templateNameResolver, PluginContext pluginContext, ProjectPermissionService projectPermissionService) {
        this.docTreeService = docTreeService;
        this.templateNameResolver = templateNameResolver;
        this.pluginContext = pluginContext;
        this.projectPermissionService = projectPermissionService;
    }
}

