/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.service.impl;

import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import run.halo.app.core.extension.content.Snapshot;
import run.halo.app.extension.Extension;
import run.halo.app.extension.Metadata;
import run.halo.app.extension.MetadataOperator;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.Ref;
import run.halo.doc.extensions.Doc;
import run.halo.doc.infra.NotFoundException;
import run.halo.doc.model.Content;
import run.halo.doc.model.DocWithContent;
import run.halo.doc.service.DocService;
import run.halo.doc.service.DocSnapshotLister;
import run.halo.doc.utils.MarkdownUtils;
import run.halo.doc.utils.PrincipalUtils;

@Component
public class DocServiceImpl
implements DocService {
    private final ReactiveExtensionClient client;
    private final DocSnapshotLister docSnapshotLister;

    static String renderMarkdown(String raw) {
        return MarkdownUtils.renderMarkdown(raw);
    }

    @Override
    public Mono<DocWithContent> draftOrUpdate(Doc doc, Content content) {
        return PrincipalUtils.currentUsername().flatMap(username -> this.draftOrUpdateContent(doc, content, (String)username).flatMap(snapshot -> {
            doc.getSpec().setHeadSnapshot(snapshot.getMetadata().getName());
            return this.createOrUpdateDoc(doc, (String)username);
        })).map(updatedDoc -> new DocWithContent().setDoc(doc).setContent(content));
    }

    @Override
    public Mono<DocWithContent> getPublishedByName(String name) {
        return this.getByName(name).filter(DocWithContent::isPublished).switchIfEmpty(Mono.error(() -> new NotFoundException("Doc does not exist or is not published")));
    }

    @Override
    public Mono<DocWithContent> getByName(String name) {
        return this.client.get(Doc.class, name).flatMap(doc -> {
            String releaseSnapshot = doc.getSpec().getReleaseSnapshot();
            if (StringUtils.isBlank((CharSequence)releaseSnapshot)) {
                return Mono.just((Object)new DocWithContent().setDoc((Doc)((Object)doc)));
            }
            return this.client.get(Snapshot.class, releaseSnapshot).map(snapshot -> {
                Snapshot.SnapShotSpec spec = snapshot.getSpec();
                return new Content(spec.getRawPatch(), spec.getContentPatch(), spec.getRawType());
            }).map(content -> new DocWithContent().setDoc((Doc)((Object)doc)).setContent((Content)content));
        }).switchIfEmpty(Mono.error(() -> new NotFoundException("Unable to find doc by name: " + name)));
    }

    @Override
    public Mono<DocWithContent> updateHeadContent(String docName, Content content) {
        return this.client.get(Doc.class, docName).flatMap(doc -> this.draftOrUpdate((Doc)((Object)doc), content));
    }

    @Override
    public Mono<Doc> deleteByName(String name) {
        return this.client.fetch(Doc.class, name).flatMap(doc -> {
            Mono deleteSnapshot = this.docSnapshotLister.listByDocName(name).flatMap(arg_0 -> ((ReactiveExtensionClient)this.client).delete(arg_0)).then();
            Mono deleteDoc = this.client.delete((Extension)doc);
            return Mono.when((Publisher[])new Publisher[]{deleteSnapshot, deleteDoc}).thenReturn((Object)doc);
        });
    }

    private Mono<Doc> createOrUpdateDoc(Doc doc, String username) {
        String docName = doc.getMetadata().getName();
        doc.getSpec().setUpdatedBy(username);
        doc.getSpec().setUpdatedAt(Instant.now());
        if (StringUtils.isBlank((CharSequence)doc.getSpec().getOwner())) {
            doc.getSpec().setOwner(username);
        }
        if (StringUtils.isBlank((CharSequence)docName)) {
            return this.client.create((Extension)doc);
        }
        return this.client.fetch(Doc.class, docName).switchIfEmpty(Mono.defer(() -> this.client.create((Extension)doc))).flatMap(existingDoc -> {
            doc.getMetadata().setVersion(existingDoc.getMetadata().getVersion());
            return this.client.update((Extension)doc);
        });
    }

    Mono<Snapshot> draftOrUpdateContent(Doc doc, Content content, String username) {
        String releaseSnapshot;
        String headSnapshot = doc.getSpec().getHeadSnapshot();
        if (StringUtils.equals((CharSequence)headSnapshot, (CharSequence)(releaseSnapshot = doc.getSpec().getReleaseSnapshot()))) {
            return this.createContent(doc, content, username);
        }
        return this.client.fetch(Snapshot.class, headSnapshot).switchIfEmpty(Mono.defer(() -> this.createContent(doc, content, username))).map(snapshot -> {
            Snapshot.SnapShotSpec spec = snapshot.getSpec();
            spec.setRawPatch(content.raw());
            spec.setContentPatch(content.content());
            spec.setRawType(content.rawType());
            spec.setLastModifyTime(Instant.now());
            if (spec.getContributors() == null) {
                spec.setContributors(new HashSet());
            }
            spec.getContributors().add(username);
            String rawType = snapshot.getSpec().getRawType();
            String raw = snapshot.getSpec().getRawPatch();
            if ("markdown".equalsIgnoreCase(rawType) && StringUtils.isNotBlank((CharSequence)raw)) {
                snapshot.getSpec().setContentPatch(DocServiceImpl.renderMarkdown(raw));
            }
            return snapshot;
        }).flatMap(arg_0 -> ((ReactiveExtensionClient)this.client).update(arg_0));
    }

    Mono<Snapshot> createContent(Doc doc, Content content, String username) {
        Snapshot snapshot = new Snapshot();
        snapshot.setMetadata((MetadataOperator)new Metadata());
        snapshot.getMetadata().setGenerateName("doc-snapshot-");
        snapshot.setSpec(new Snapshot.SnapShotSpec());
        Snapshot.SnapShotSpec spec = snapshot.getSpec();
        spec.setRawPatch(content.raw());
        spec.setContentPatch(content.content());
        spec.setRawType(content.rawType());
        spec.setSubjectRef(Ref.of((Extension)doc));
        spec.setOwner(username);
        spec.setLastModifyTime(Instant.now());
        spec.setContributors(Set.of(username));
        spec.setParentSnapshotName(doc.getSpec().getHeadSnapshot());
        return this.client.create((Extension)snapshot);
    }

    @Generated
    public DocServiceImpl(ReactiveExtensionClient client, DocSnapshotLister docSnapshotLister) {
        this.client = client;
        this.docSnapshotLister = docSnapshotLister;
    }
}

