/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.reconciler;

import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;
import run.halo.app.extension.AbstractExtension;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionClient;
import run.halo.app.extension.ExtensionOperator;
import run.halo.app.extension.ExtensionUtil;
import run.halo.app.extension.MetadataOperator;
import run.halo.app.extension.MetadataUtil;
import run.halo.app.extension.controller.Controller;
import run.halo.app.extension.controller.ControllerBuilder;
import run.halo.app.extension.controller.Reconciler;
import run.halo.doc.event.PreferVersionChangedEvent;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.service.ProjectVersionLister;

@Component
public class ProjectReconciler
implements Reconciler<Reconciler.Request> {
    static final String FINALIZER = "doc.halo.run/project-protection";
    private final ExtensionClient client;
    private final ProjectVersionLister projectVersionLister;
    private final ApplicationEventPublisher eventPublisher;
    private final RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(5).fixedBackoff(100L).retryOn(OptimisticLockingFailureException.class).build();

    public Reconciler.Result reconcile(Reconciler.Request request) {
        this.client.fetch(Project.class, request.name()).ifPresent(project -> {
            if (ExtensionUtil.isDeleted((ExtensionOperator)project)) {
                if (ExtensionUtil.removeFinalizers((MetadataOperator)project.getMetadata(), Set.of(FINALIZER))) {
                    this.deleteRelatedExtensions((Project)((Object)project));
                    this.client.update((Extension)project);
                }
                return;
            }
            ExtensionUtil.addFinalizers((MetadataOperator)project.getMetadata(), Set.of(FINALIZER));
            project.getStatus().setPermalink(this.generatePermalink((Project)((Object)project)));
            this.refreshProjectVersion((Project)((Object)project));
            if (this.preferredVersionChanged((Project)((Object)project))) {
                this.eventPublisher.publishEvent((ApplicationEvent)new PreferVersionChangedEvent(this, project.getMetadata().getName()));
            }
            this.client.update((Extension)project);
        });
        return null;
    }

    void refreshProjectVersion(Project project) {
        List<ProjectVersion> versions = this.listVersionByProject(project.getMetadata().getName());
        String preferredVersionName = this.getPreferredVersionName(project);
        for (ProjectVersion version : versions) {
            MetadataUtil.nullSafeAnnotations((AbstractExtension)version).put("doc.halo.run/preferred-version", preferredVersionName);
            MetadataUtil.nullSafeAnnotations((AbstractExtension)version).put("doc.halo.run/preferred-language", project.getSpec().getPreferredLanguage());
            MetadataUtil.nullSafeAnnotations((AbstractExtension)version).put("doc.halo.run/project-slug", project.getSpec().getSlug());
            MetadataUtil.nullSafeLabels((AbstractExtension)version).put("doc.halo.run/marked-as-preferred", String.valueOf(version.getMetadata().getName().equals(preferredVersionName)));
            this.updateVersionWithRetry(version);
        }
    }

    boolean preferredVersionChanged(Project project) {
        String newPreferredVersion;
        String oldPreferredVersion = (String)MetadataUtil.nullSafeLabels((AbstractExtension)project).get("doc.halo.run/preferred-version");
        return !StringUtils.equals((CharSequence)oldPreferredVersion, (CharSequence)(newPreferredVersion = this.getPreferredVersionName(project)));
    }

    String generatePermalink(Project project) {
        return "/docs/" + project.getSpec().getSlug();
    }

    private List<ProjectVersion> listVersionByProject(String projectName) {
        return this.projectVersionLister.listByProjectName(projectName).collectList().blockOptional().orElse(List.of());
    }

    private void updateVersionWithRetry(ProjectVersion version) {
        try {
            this.client.update((Extension)version);
        }
        catch (OptimisticLockingFailureException e) {
            this.retryTemplate.execute(retryCallback -> {
                this.client.fetch(ProjectVersion.class, version.getMetadata().getName()).ifPresent(latest -> {
                    version.getMetadata().setVersion(latest.getMetadata().getVersion());
                    this.client.update((Extension)version);
                });
                return null;
            });
        }
    }

    String getPreferredVersionName(Project project) {
        Project.VersionRef versionRef = project.getSpec().getPreferredVersionRef();
        return versionRef == null ? null : versionRef.getName();
    }

    void deleteRelatedExtensions(Project project) {
        this.client.list(ProjectVersion.class, version -> project.getMetadata().getName().equals(version.getSpec().getProjectName()), null).forEach(arg_0 -> ((ExtensionClient)this.client).delete(arg_0));
    }

    public Controller setupWith(ControllerBuilder builder) {
        return builder.extension((Extension)new Project()).build();
    }

    @Generated
    public ProjectReconciler(ExtensionClient client, ProjectVersionLister projectVersionLister, ApplicationEventPublisher eventPublisher) {
        this.client = client;
        this.projectVersionLister = projectVersionLister;
        this.eventPublisher = eventPublisher;
    }
}

