/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.reconciler;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;
import run.halo.app.extension.AbstractExtension;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionClient;
import run.halo.app.extension.ExtensionOperator;
import run.halo.app.extension.ExtensionUtil;
import run.halo.app.extension.MetadataOperator;
import run.halo.app.extension.MetadataUtil;
import run.halo.app.extension.controller.Controller;
import run.halo.app.extension.controller.ControllerBuilder;
import run.halo.app.extension.controller.Reconciler;
import run.halo.app.infra.Condition;
import run.halo.app.infra.ConditionStatus;
import run.halo.doc.event.DocTreeNodeChangedEvent;
import run.halo.doc.extensions.Doc;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.model.DocTreeIdentity;
import run.halo.doc.service.DocService;
import run.halo.doc.service.DocTreeLister;
import run.halo.doc.theme.DocTreeRouteMap;
import run.halo.doc.utils.DocTreeUtils;
import run.halo.doc.utils.NaryTreeWalker;

@Component
public class DocTreeReconciler
implements Reconciler<Reconciler.Request> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocTreeReconciler.class);
    static final String FINALIZER = "doc.halo.run/protection";
    private final ExtensionClient client;
    private final DocTreeLister docTreeLister;
    private final DocTreeRouteMap docTreeRouteMap;
    private final DocService docService;
    private final ApplicationEventPublisher eventPublisher;
    private final RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(5).fixedBackoff(100L).retryOn(OptimisticLockingFailureException.class).build();

    private static Map<String, DocTree> getLanguageNodeMap(List<DocTree> docTreeList) {
        return docTreeList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getSpec().getParent())).filter(item -> !DocTree.isDoc(item)).filter(item -> {
            String markedAsLang = (String)MetadataUtil.nullSafeLabels((AbstractExtension)item).get("doc.halo.run/marked-as-language");
            return "true".equals(markedAsLang);
        }).collect(Collectors.toMap(item -> item.getMetadata().getName(), item -> item));
    }

    private static DocTreeIdentity createDocTreeIdentity(DocTree docTree) {
        String docTreeName = docTree.getMetadata().getName();
        return DocTreeIdentity.builder().name(docTreeName).type(docTree.getSpec().getType().name()).versionName(docTree.getSpec().getProjectVersionName()).docName(docTree.getSpec().getDocName()).markedAsLanguage("true".equals(MetadataUtil.nullSafeLabels((AbstractExtension)docTree).get("doc.halo.run/marked-as-language"))).build();
    }

    public Reconciler.Result reconcile(Reconciler.Request request) {
        this.client.fetch(DocTree.class, request.name()).ifPresent(docTree -> {
            if (ExtensionUtil.isDeleted((ExtensionOperator)docTree)) {
                if (ExtensionUtil.removeFinalizers((MetadataOperator)docTree.getMetadata(), Set.of(FINALIZER))) {
                    this.deleteRelatedExtensions((DocTree)((Object)docTree));
                    this.client.update((Extension)docTree);
                    this.eventPublisher.publishEvent((ApplicationEvent)DocTreeNodeChangedEvent.ofDelete(this, docTree));
                }
                return;
            }
            ExtensionUtil.addFinalizers((MetadataOperator)docTree.getMetadata(), Set.of(FINALIZER));
            if (docTree.getMetadata().getName().equals(docTree.getSpec().getParent())) {
                docTree.getSpec().setParent(null);
            }
            this.generatePermalinkAndPath((DocTree)((Object)docTree));
            this.syncPublishStatus((DocTree)((Object)docTree));
            docTree.getStatus().setObservedVersion(docTree.getMetadata().getVersion() + 1L);
            this.client.update((Extension)docTree);
            this.eventPublisher.publishEvent((ApplicationEvent)DocTreeNodeChangedEvent.ofUpdate(this, docTree));
        });
        return Reconciler.Result.doNotRetry();
    }

    void syncPublishStatus(DocTree docTree) {
        if (!DocTree.isDoc(docTree)) {
            return;
        }
        this.client.fetch(Doc.class, docTree.getSpec().getDocName()).ifPresent(doc -> docTree.getStatus().setPublished(Doc.isPublished(doc)));
    }

    ProjectInfo getProjectVersionInfo(DocTree docTree) {
        ProjectVersion projectVersion = (ProjectVersion)((Object)this.client.fetch(ProjectVersion.class, docTree.getSpec().getProjectVersionName()).orElseThrow(() -> new IllegalArgumentException("Project version not found")));
        Map annotations = MetadataUtil.nullSafeAnnotations((AbstractExtension)projectVersion);
        String preferredVersionName = (String)annotations.get("doc.halo.run/preferred-version");
        String preferredLang = (String)annotations.get("doc.halo.run/preferred-language");
        String projectSlug = (String)annotations.get("doc.halo.run/project-slug");
        String versionSlug = projectVersion.getSpec().getSlug();
        return ProjectInfo.builder().preferredVersionName(preferredVersionName).preferredLang(preferredLang).projectSlug(projectSlug).versionSlug(versionSlug).build();
    }

    void deleteRelatedExtensions(DocTree docTree) {
        String targetTreeName = docTree.getMetadata().getName();
        if (DocTree.isDoc(docTree)) {
            String docName = docTree.getSpec().getDocName();
            this.docService.deleteByName(docName).block();
            return;
        }
        String versionName = docTree.getSpec().getProjectVersionName();
        List<DocTree> docTrees = this.docTreeLister.listByVersion(versionName).collectList().blockOptional().orElse(List.of());
        for (DocTree node : this.getChildrenByName(targetTreeName, docTrees)) {
            this.client.delete((Extension)node);
        }
    }

    List<DocTree> getChildrenByName(String docTreeName, List<DocTree> trees) {
        Map<String, DocTree> nameDocTreeMap = trees.stream().collect(Collectors.toMap(docTree -> docTree.getMetadata().getName(), docTree -> docTree));
        List<DocTreeNode> nodeList = trees.stream().map(docTree -> new DocTreeNode(docTree.getMetadata().getName(), docTree.getSpec().getParent())).toList();
        NaryTreeWalker<DocTreeNode> naryTree = NaryTreeWalker.of(nodeList);
        List<DocTreeNode> subTree = naryTree.findChildren(docTreeName);
        return NaryTreeWalker.treeToList(subTree).stream().map(node -> (DocTree)((Object)((Object)nameDocTreeMap.get(node.getName())))).toList();
    }

    boolean permalinkDoesNotConflict(List<DocTree> docTreeList, DocTree currentDocTree, String targetPermalink) {
        long existingPermalinkCount = docTreeList.stream().map(docTree -> docTree.getStatus().getPermalink()).filter(StringUtils::isNotBlank).filter(targetPermalink::equals).count();
        if (existingPermalinkCount > 1L) {
            log.debug("The permalink [{}] conflicts with other doc tree for [{}]", (Object)targetPermalink, (Object)currentDocTree.getMetadata().getName());
            Condition condition = Condition.builder().type(DocTree.ConditionType.INVALID.name()).reason("Duplicate").message("The slug is already exist, please change another one.").status(ConditionStatus.FALSE).lastTransitionTime(Instant.now()).build();
            currentDocTree.getStatus().getConditions().addAndEvictFIFO(condition);
            return false;
        }
        return true;
    }

    void generatePermalinkAndPath(DocTree docTree) {
        String projectVersionName = docTree.getSpec().getProjectVersionName();
        String docTreeName = docTree.getMetadata().getName();
        ProjectInfo projectInfo = this.getProjectVersionInfo(docTree);
        List<DocTree> docTreeList = this.docTreeLister.listByVersion(projectVersionName).collectList().blockOptional().orElse(List.of());
        Map<String, DocTree> languageNodeMap = DocTreeReconciler.getLanguageNodeMap(docTreeList);
        Map<String, String> nameSlugMap = docTreeList.stream().collect(Collectors.toMap(docTreeItem -> docTreeItem.getMetadata().getName(), docTreeItem -> docTreeItem.getSpec().getSlug()));
        List<DocTreeNode> nodeList = docTreeList.stream().map(item -> new DocTreeNode(item.getMetadata().getName(), item.getSpec().getParent())).toList();
        NaryTreeWalker<DocTreeNode> naryTree = NaryTreeWalker.of(nodeList);
        List<DocTreeNode> pathTokenList = naryTree.computeNodePath((DocTreeNode)((Object)docTreeName));
        if (!pathTokenList.isEmpty()) {
            Optional.ofNullable(languageNodeMap.get(pathTokenList.get(0))).filter(langNode -> StringUtils.equals((CharSequence)langNode.getSpec().getSlug(), (CharSequence)projectInfo.preferredLang())).ifPresent(langNode -> pathTokenList.remove(0));
        }
        String nodePath = pathTokenList.stream().map(nameSlugMap::get).collect(Collectors.joining("/"));
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("projectSlug", projectInfo.projectSlug());
        if (!projectVersionName.equals(projectInfo.preferredVersionName())) {
            uriVariables.put("versionSlug", projectInfo.versionSlug());
        }
        uriVariables.put("docTreePath", nodePath);
        String permalink = DocTreeUtils.buildRoutePathWithGivenVariables(uriVariables);
        if (this.permalinkDoesNotConflict(docTreeList, docTree, permalink)) {
            Optional.ofNullable(docTree.getStatus().getPermalink()).ifPresent(this.docTreeRouteMap::remove);
            docTree.getStatus().setPermalink(permalink);
            this.docTreeRouteMap.put(permalink, DocTreeReconciler.createDocTreeIdentity(docTree));
        }
        MetadataUtil.nullSafeAnnotations((AbstractExtension)docTree).put("doc.halo.run/tree-node-path", nodePath);
        List<DocTreeNode> subTree = naryTree.findChildren(docTreeName);
        NaryTreeWalker.treeToList(subTree).forEach(subNode -> {
            String subNodePath = naryTree.computeNodePath((DocTreeNode)((Object)subNode.getName())).stream().map(nameSlugMap::get).collect(Collectors.joining("/"));
            this.updateSubNodePath(subNode.getName(), subNodePath);
        });
    }

    void updateSubNodePath(String name, String nodePath) {
        this.retryTemplate.execute(retryCallback -> {
            this.client.fetch(DocTree.class, name).ifPresent(docTree -> {
                MetadataUtil.nullSafeAnnotations((AbstractExtension)docTree).put("doc.halo.run/tree-node-path", nodePath);
                this.client.update((Extension)docTree);
            });
            return null;
        });
    }

    public Controller setupWith(ControllerBuilder builder) {
        return builder.extension((Extension)new DocTree()).build();
    }

    @Generated
    public DocTreeReconciler(ExtensionClient client, DocTreeLister docTreeLister, DocTreeRouteMap docTreeRouteMap, DocService docService, ApplicationEventPublisher eventPublisher) {
        this.client = client;
        this.docTreeLister = docTreeLister;
        this.docTreeRouteMap = docTreeRouteMap;
        this.docService = docService;
        this.eventPublisher = eventPublisher;
    }

    record ProjectInfo(String preferredVersionName, String preferredLang, String projectSlug, String versionSlug) {
        @Generated
        public static ProjectInfoBuilder builder() {
            return new ProjectInfoBuilder();
        }

        @Generated
        public static class ProjectInfoBuilder {
            @Generated
            private String preferredVersionName;
            @Generated
            private String preferredLang;
            @Generated
            private String projectSlug;
            @Generated
            private String versionSlug;

            @Generated
            ProjectInfoBuilder() {
            }

            @Generated
            public ProjectInfoBuilder preferredVersionName(String preferredVersionName) {
                this.preferredVersionName = preferredVersionName;
                return this;
            }

            @Generated
            public ProjectInfoBuilder preferredLang(String preferredLang) {
                this.preferredLang = preferredLang;
                return this;
            }

            @Generated
            public ProjectInfoBuilder projectSlug(String projectSlug) {
                this.projectSlug = projectSlug;
                return this;
            }

            @Generated
            public ProjectInfoBuilder versionSlug(String versionSlug) {
                this.versionSlug = versionSlug;
                return this;
            }

            @Generated
            public ProjectInfo build() {
                return new ProjectInfo(this.preferredVersionName, this.preferredLang, this.projectSlug, this.versionSlug);
            }

            @Generated
            public String toString() {
                return "DocTreeReconciler.ProjectInfo.ProjectInfoBuilder(preferredVersionName=" + this.preferredVersionName + ", preferredLang=" + this.preferredLang + ", projectSlug=" + this.projectSlug + ", versionSlug=" + this.versionSlug + ")";
            }
        }
    }

    static class DocTreeNode
    extends NaryTreeWalker.TreeNode<DocTreeNode> {
        public DocTreeNode(String name, String parent) {
            super(name, parent);
        }
    }
}

