/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.reconciler;

import lombok.Generated;
import org.springframework.stereotype.Component;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionClient;
import run.halo.app.extension.controller.Controller;
import run.halo.app.extension.controller.ControllerBuilder;
import run.halo.app.extension.controller.Reconciler;
import run.halo.doc.extensions.Doc;
import run.halo.doc.extensions.DocTree;

@Component
public class DocReconciler
implements Reconciler<Reconciler.Request> {
    private final ExtensionClient client;

    public Reconciler.Result reconcile(Reconciler.Request request) {
        this.client.fetch(Doc.class, request.name()).ifPresent(doc -> {
            String headSnapshot = doc.getSpec().getHeadSnapshot();
            String releaseSnapshot = doc.getSpec().getReleaseSnapshot();
            doc.getStatus().setInProgress(!headSnapshot.equals(releaseSnapshot));
            String docTreeName = doc.getSpec().getDocTreeName();
            this.client.fetch(DocTree.class, docTreeName).ifPresent(docTree -> {
                docTree.getStatus().setInProgress(doc.getStatus().isInProgress());
                docTree.getStatus().setPublished(Doc.isPublished(doc));
                this.client.update((Extension)docTree);
            });
            this.client.update((Extension)doc);
        });
        return Reconciler.Result.doNotRetry();
    }

    public Controller setupWith(ControllerBuilder builder) {
        return builder.extension((Extension)new Doc()).build();
    }

    @Generated
    public DocReconciler(ExtensionClient client) {
        this.client = client;
    }
}

