/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class TreePrinter {
    private List<Node> nodes;
    private boolean withId;
    private boolean withDirFlag;

    public TreePrinter(List<Node> nodes) {
        this.nodes = nodes;
    }

    public String printTree() {
        HashMap<String, List<Node>> map = new HashMap<String, List<Node>>();
        for (Node node : this.nodes) {
            map.computeIfAbsent(node.parentId, k -> new ArrayList()).add(node);
        }
        StringBuilder sb = new StringBuilder();
        for (Node node : this.nodes) {
            if (node.getParentId() != null) continue;
            this.printNode(sb, node, "", true, map);
        }
        return sb.toString();
    }

    void printNode(StringBuilder sb, Node node, String prefix, boolean isTail, Map<String, List<Node>> map) {
        sb.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(node.title);
        if (this.withDirFlag) {
            sb.append(node.isDir ? "" : " *");
        }
        if (this.withId) {
            sb.append(" [id: ").append(node.id).append("]");
        }
        sb.append("\n");
        List<Node> children = map.get(node.id);
        if (children != null) {
            for (int i = 0; i < children.size() - 1; ++i) {
                this.printNode(sb, children.get(i), prefix + (isTail ? "    " : "\u2502   "), false, map);
            }
            if (!children.isEmpty()) {
                this.printNode(sb, children.get(children.size() - 1), prefix + (isTail ? "    " : "\u2502   "), true, map);
            }
        }
    }

    @Generated
    public List<Node> getNodes() {
        return this.nodes;
    }

    @Generated
    public boolean isWithId() {
        return this.withId;
    }

    @Generated
    public boolean isWithDirFlag() {
        return this.withDirFlag;
    }

    @Generated
    public TreePrinter setNodes(List<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    @Generated
    public TreePrinter setWithId(boolean withId) {
        this.withId = withId;
        return this;
    }

    @Generated
    public TreePrinter setWithDirFlag(boolean withDirFlag) {
        this.withDirFlag = withDirFlag;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreePrinter)) {
            return false;
        }
        TreePrinter other = (TreePrinter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWithId() != other.isWithId()) {
            return false;
        }
        if (this.isWithDirFlag() != other.isWithDirFlag()) {
            return false;
        }
        List<Node> this$nodes = this.getNodes();
        List<Node> other$nodes = other.getNodes();
        return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TreePrinter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWithId() ? 79 : 97);
        result = result * 59 + (this.isWithDirFlag() ? 79 : 97);
        List<Node> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TreePrinter(nodes=" + String.valueOf(this.getNodes()) + ", withId=" + this.isWithId() + ", withDirFlag=" + this.isWithDirFlag() + ")";
    }

    public static final class Node {
        private final String id;
        private final String title;
        private final boolean isDir;
        private final String parentId;

        @Generated
        Node(String id, String title, boolean isDir, String parentId) {
            this.id = id;
            this.title = title;
            this.isDir = isDir;
            this.parentId = parentId;
        }

        @Generated
        public static NodeBuilder builder() {
            return new NodeBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public boolean isDir() {
            return this.isDir;
        }

        @Generated
        public String getParentId() {
            return this.parentId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (this.isDir() != other.isDir()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$parentId = this.getParentId();
            String other$parentId = other.getParentId();
            return !(this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDir() ? 79 : 97);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TreePrinter.Node(id=" + this.getId() + ", title=" + this.getTitle() + ", isDir=" + this.isDir() + ", parentId=" + this.getParentId() + ")";
        }

        @Generated
        public static class NodeBuilder {
            @Generated
            private String id;
            @Generated
            private String title;
            @Generated
            private boolean isDir;
            @Generated
            private String parentId;

            @Generated
            NodeBuilder() {
            }

            @Generated
            public NodeBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public NodeBuilder title(String title) {
                this.title = title;
                return this;
            }

            @Generated
            public NodeBuilder isDir(boolean isDir) {
                this.isDir = isDir;
                return this;
            }

            @Generated
            public NodeBuilder parentId(String parentId) {
                this.parentId = parentId;
                return this;
            }

            @Generated
            public Node build() {
                return new Node(this.id, this.title, this.isDir, this.parentId);
            }

            @Generated
            public String toString() {
                return "TreePrinter.Node.NodeBuilder(id=" + this.id + ", title=" + this.title + ", isDir=" + this.isDir + ", parentId=" + this.parentId + ")";
            }
        }
    }
}

