/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.Assert;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.utils.NaryTreeWalker;

public class ProjectVersionSorter {
    private final Map<String, ProjectVersion> nameVersionMap;
    private final List<VersionNode> treeNodes;

    public ProjectVersionSorter(List<ProjectVersion> versions) {
        Assert.notNull(versions, (String)"Versions must not be null");
        List<VersionNode> nodeList = versions.stream().map(version -> new VersionNode(version.getMetadata().getName(), version.getSpec().getParentVersion(), version.getMetadata().getCreationTimestamp())).toList();
        this.treeNodes = NaryTreeWalker.listToTree(nodeList);
        this.treeNodes.sort(Comparator.comparing(VersionNode::getCreationTime).reversed());
        this.nameVersionMap = versions.stream().collect(Collectors.toMap(version -> version.getMetadata().getName(), Function.identity()));
    }

    public static ProjectVersionSorter of(List<ProjectVersion> versions) {
        return new ProjectVersionSorter(versions);
    }

    static List<VersionNode> dfs(List<VersionNode> treeNodes) {
        ArrayList<VersionNode> result = new ArrayList<VersionNode>();
        for (VersionNode versionNode : treeNodes) {
            ArrayList<VersionNode> nodeVersions = new ArrayList<VersionNode>();
            ProjectVersionSorter.dfs(versionNode, nodeVersions);
            result.addAll(nodeVersions);
        }
        return result;
    }

    static void dfs(VersionNode root, List<VersionNode> result) {
        if (root == null) {
            return;
        }
        result.add(0, root);
        for (VersionNode child : root.getChildren()) {
            ProjectVersionSorter.dfs(child, result);
        }
    }

    public List<ProjectVersion> sortedVersions() {
        return ProjectVersionSorter.dfs(this.treeNodes).stream().map(NaryTreeWalker.TreeNode::getName).map(this.nameVersionMap::get).toList();
    }

    static class VersionNode
    extends NaryTreeWalker.TreeNode<VersionNode> {
        private final Instant creationTime;

        public VersionNode(String name, String parent, Instant creationTime) {
            super(name, parent);
            this.creationTime = (Instant)ObjectUtils.defaultIfNull((Object)creationTime, (Object)Instant.now());
        }

        @Generated
        public Instant getCreationTime() {
            return this.creationTime;
        }
    }
}

