/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.infra.flexmark.admonitions;

import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.DelegatingNodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.springframework.lang.NonNull;
import run.halo.doc.infra.flexmark.admonitions.AdmonitionBlock;

public class AdmonitionNodeRenderer
implements NodeRenderer {
    AdmonitionNodeRenderer(DataHolder options) {
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<AdmonitionBlock>(AdmonitionBlock.class, this.admonitionBlockRenderer()));
        return set;
    }

    private NodeRenderingHandler.CustomNodeRenderer<AdmonitionBlock> admonitionBlockRenderer() {
        return (block, context, html) -> {
            html.line();
            ((HtmlWriter)html.withAttr().attr("class", "admonition admonition-" + String.valueOf(block.getType()))).tagIndent("div", () -> {
                ((HtmlWriter)html.withAttr().attr("class", "admonition-heading")).tagIndent("div", () -> {
                    ((HtmlWriter)html.withAttr().attr("class", "admonition-icon")).tag((CharSequence)"span", () -> {
                        AdmonitionBlock.TypeIcon typeIcon = AdmonitionBlock.TypeIcon.fromString(block.getType().toString());
                        html.raw(typeIcon.getIcon());
                    });
                    html.raw(StringUtils.defaultIfBlank((CharSequence)block.getTitle(), (CharSequence)((BasedSequence)block.getType().toUpperCase())));
                });
                ((HtmlWriter)html.withAttr().attr("class", "admonition-content")).tagIndent("div", () -> context.renderChildren(block));
            });
            html.line();
        };
    }

    public static class Factory
    implements DelegatingNodeRendererFactory {
        @Override
        @NonNull
        public NodeRenderer apply(@NonNull DataHolder options) {
            return new AdmonitionNodeRenderer(options);
        }

        @Override
        @Nullable
        public Set<Class<?>> getDelegates() {
            return null;
        }
    }
}

