/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.extensions;

import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import lombok.Generated;
import org.springframework.lang.NonNull;
import run.halo.app.extension.AbstractExtension;
import run.halo.app.extension.GVK;

@GVK(group="doc.halo.run", version="v1alpha1", kind="ProjectVersion", plural="projectversions", singular="projectversion")
public class ProjectVersion
extends AbstractExtension {
    public static final String COPY_FROM_PRE_VERSION = "doc.halo.run/copy-from-pre-version";
    public static final String PUBLISHED_LABEL = "doc.halo.run/published";
    public static final String PREFERRED_LABEL = "doc.halo.run/marked-as-preferred";
    public static final String PROJECT_SLUG_ANNO = "doc.halo.run/project-slug";
    public static final String PREFERRED_VERSION_ANNO = "doc.halo.run/preferred-version";
    public static final String PREFERRED_LANG_ANNO = "doc.halo.run/preferred-language";
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private Spec spec;
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private Status status = new Status();

    public static boolean isPublished(ProjectVersion projectVersion) {
        return projectVersion.getSpec().isPublish();
    }

    public void setStatus(Status status) {
        this.status = status == null ? new Status() : status;
    }

    @Generated
    public ProjectVersion() {
    }

    @Generated
    public Spec getSpec() {
        return this.spec;
    }

    @Generated
    public void setSpec(Spec spec) {
        this.spec = spec;
    }

    @Generated
    public String toString() {
        return "ProjectVersion(spec=" + String.valueOf(this.getSpec()) + ", status=" + String.valueOf(this.getStatus()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectVersion)) {
            return false;
        }
        ProjectVersion other = (ProjectVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spec this$spec = this.getSpec();
        Spec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)this$status).equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjectVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Spec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Schema(name="ProjectVersionSpec")
    public static class Spec {
        @Schema(requiredMode=Schema.RequiredMode.REQUIRED, minLength=1)
        private String projectName;
        @Schema(requiredMode=Schema.RequiredMode.REQUIRED, minLength=1)
        private String slug;
        @Schema(requiredMode=Schema.RequiredMode.REQUIRED, minLength=1)
        private String owner;
        private boolean publish;
        private Instant publishedAt;
        private String parentVersion;

        @Generated
        public Spec() {
        }

        @Generated
        public String getProjectName() {
            return this.projectName;
        }

        @Generated
        public String getSlug() {
            return this.slug;
        }

        @Generated
        public String getOwner() {
            return this.owner;
        }

        @Generated
        public boolean isPublish() {
            return this.publish;
        }

        @Generated
        public Instant getPublishedAt() {
            return this.publishedAt;
        }

        @Generated
        public String getParentVersion() {
            return this.parentVersion;
        }

        @Generated
        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Generated
        public void setSlug(String slug) {
            this.slug = slug;
        }

        @Generated
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @Generated
        public void setPublish(boolean publish) {
            this.publish = publish;
        }

        @Generated
        public void setPublishedAt(Instant publishedAt) {
            this.publishedAt = publishedAt;
        }

        @Generated
        public void setParentVersion(String parentVersion) {
            this.parentVersion = parentVersion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Spec)) {
                return false;
            }
            Spec other = (Spec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPublish() != other.isPublish()) {
                return false;
            }
            String this$projectName = this.getProjectName();
            String other$projectName = other.getProjectName();
            if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
                return false;
            }
            String this$slug = this.getSlug();
            String other$slug = other.getSlug();
            if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
                return false;
            }
            String this$owner = this.getOwner();
            String other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
                return false;
            }
            Instant this$publishedAt = this.getPublishedAt();
            Instant other$publishedAt = other.getPublishedAt();
            if (this$publishedAt == null ? other$publishedAt != null : !((Object)this$publishedAt).equals(other$publishedAt)) {
                return false;
            }
            String this$parentVersion = this.getParentVersion();
            String other$parentVersion = other.getParentVersion();
            return !(this$parentVersion == null ? other$parentVersion != null : !this$parentVersion.equals(other$parentVersion));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Spec;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPublish() ? 79 : 97);
            String $projectName = this.getProjectName();
            result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
            String $slug = this.getSlug();
            result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
            String $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
            Instant $publishedAt = this.getPublishedAt();
            result = result * 59 + ($publishedAt == null ? 43 : ((Object)$publishedAt).hashCode());
            String $parentVersion = this.getParentVersion();
            result = result * 59 + ($parentVersion == null ? 43 : $parentVersion.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProjectVersion.Spec(projectName=" + this.getProjectName() + ", slug=" + this.getSlug() + ", owner=" + this.getOwner() + ", publish=" + this.isPublish() + ", publishedAt=" + String.valueOf(this.getPublishedAt()) + ", parentVersion=" + this.getParentVersion() + ")";
        }
    }

    @Schema(name="ProjectVersionStatus")
    public static class Status {
        private boolean readiness;
        private String permalink;

        @Generated
        public Status() {
        }

        @Generated
        public boolean isReadiness() {
            return this.readiness;
        }

        @Generated
        public String getPermalink() {
            return this.permalink;
        }

        @Generated
        public void setReadiness(boolean readiness) {
            this.readiness = readiness;
        }

        @Generated
        public void setPermalink(String permalink) {
            this.permalink = permalink;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status other = (Status)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isReadiness() != other.isReadiness()) {
                return false;
            }
            String this$permalink = this.getPermalink();
            String other$permalink = other.getPermalink();
            return !(this$permalink == null ? other$permalink != null : !this$permalink.equals(other$permalink));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Status;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isReadiness() ? 79 : 97);
            String $permalink = this.getPermalink();
            result = result * 59 + ($permalink == null ? 43 : $permalink.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProjectVersion.Status(readiness=" + this.isReadiness() + ", permalink=" + this.getPermalink() + ")";
        }
    }
}

