/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.event;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.event.EventListener;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.lang.NonNull;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionClient;
import run.halo.doc.event.DocTreeNodeChangedEvent;
import run.halo.doc.event.PreferVersionChangedEvent;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.service.DocTreeLister;

@Component
public class ProjectTotalDocsUpdater {
    private final RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(5).fixedBackoff(100L).retryOn(OptimisticLockingFailureException.class).build();
    private final DocTreeLister docTreeLister;
    private final ExtensionClient client;

    @Async
    @EventListener(value={DocTreeNodeChangedEvent.class})
    public void onDocTreeNodeChanged(@NonNull DocTreeNodeChangedEvent event) {
        this.retryTemplate.execute(retryCallback -> {
            this.updateTotalDocs(event);
            return null;
        });
    }

    @Async
    @EventListener(value={PreferVersionChangedEvent.class})
    public void onPreferVersionChanged(@NonNull PreferVersionChangedEvent event) {
        this.retryTemplate.execute(retryCallback -> {
            this.recountTotalDocs(event.getProjectName());
            return null;
        });
    }

    private void recountTotalDocs(String projectName) {
        this.client.fetch(Project.class, projectName).ifPresent(project -> {
            Project.VersionRef preferred = project.getSpec().getPreferredVersionRef();
            if (preferred == null || StringUtils.isBlank((CharSequence)preferred.getName())) {
                return;
            }
            String preferredVersionName = preferred.getName();
            Long docCount = this.docTreeLister.listByVersion(preferredVersionName).filter(DocTree::isDoc).count().blockOptional().orElse(0L);
            Project.Status status = project.getStatus();
            status.setTotalDocs(docCount.intValue());
            this.client.update((Extension)project);
        });
    }

    public void updateTotalDocs(DocTreeNodeChangedEvent event) {
        DocTree docTree = event.getDocTree();
        String versionName = docTree.getSpec().getProjectVersionName();
        this.client.fetch(ProjectVersion.class, versionName).ifPresent(projectVersion -> {
            String projectName = projectVersion.getSpec().getProjectName();
            this.recountTotalDocs(projectName);
        });
    }

    @Generated
    public ProjectTotalDocsUpdater(DocTreeLister docTreeLister, ExtensionClient client) {
        this.docTreeLister = docTreeLister;
        this.client = client;
    }
}

