/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.endpoint;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import lombok.Generated;
import org.springdoc.core.fn.builders.apiresponse.Builder;
import org.springdoc.webflux.core.fn.SpringdocRouteBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;
import run.halo.app.core.extension.endpoint.CustomEndpoint;
import run.halo.app.extension.GroupVersion;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.Scheme;
import run.halo.app.extension.SchemeManager;
import run.halo.doc.endpoint.ExtensionHandler;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.model.Language;
import run.halo.doc.service.DocTreeLister;
import run.halo.doc.service.ProjectPermissionService;

@Component
public class ProjectVersionEndpoint
implements CustomEndpoint {
    private final DocTreeLister docTreeLister;
    private final ReactiveExtensionClient client;
    private final ExtensionHandler extensionHandler;
    private final ProjectPermissionService projectPermissionService;
    private final SchemeManager schemeManager;

    public RouterFunction<ServerResponse> endpoint() {
        String tag = "api.uc.doc.halo.run/v1alpha1/ProjectVersion";
        return SpringdocRouteBuilder.route().GET("projectversions/{name}/tree", this::listDocTreeByVersion, builder -> builder.operationId("ListDocTreeByVersion").description("List doc tree by version").tag("api.uc.doc.halo.run/v1alpha1/ProjectVersion").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementationArray(DocTree.class))).GET("projectversions/{name}/languages", this::listSupportedLanguages, builder -> builder.operationId("ListSupportedLanguagesByVersion").description("List supported languages by version").tag("api.uc.doc.halo.run/v1alpha1/ProjectVersion").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementationArray(Language.class))).PUT("projectversions/{name}", this::updateVersion, builder -> builder.operationId("UpdateProjectVersion").description("Update project version").tag("api.uc.doc.halo.run/v1alpha1/ProjectVersion").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().implementation(ProjectVersion.class)).response(Builder.responseBuilder().implementation(ProjectVersion.class))).PATCH("projectversions/{name}", this::pathVersion, builder -> ExtensionHandler.buildPatchApiDoc(builder, "api.uc.doc.halo.run/v1alpha1/ProjectVersion", Scheme.buildFromType(ProjectVersion.class))).DELETE("projectversions/{name}", this::deleteVersion, builder -> builder.operationId("DeleteProjectVersion").description("Delete project version").tag("api.uc.doc.halo.run/v1alpha1/ProjectVersion").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().responseCode("204").description("Project version deleted successfully"))).POST("/projectversions/{name}/tree", this::createDocTree, builder -> builder.operationId("CreateDocTree").description("Create doc tree under project version").tag("api.uc.doc.halo.run/v1alpha1/ProjectVersion").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().implementation(DocTree.class)).response(Builder.responseBuilder().implementation(DocTree.class))).build();
    }

    private Mono<ServerResponse> deleteVersion(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.checkPermission(name, Project.PermissionLevel.ADMIN).then(this.extensionHandler.handleDelete(request, this.schemeManager.get(ProjectVersion.class)));
    }

    private Mono<ServerResponse> pathVersion(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.checkPermission(name, Project.PermissionLevel.WRITE).then(this.extensionHandler.handlePatch(request, this.schemeManager.get(ProjectVersion.class)));
    }

    private Mono<ServerResponse> createDocTree(ServerRequest request) {
        String versionName = request.pathVariable("name");
        return this.checkPermission(versionName, Project.PermissionLevel.WRITE).then(this.extensionHandler.handleCreate(request, this.schemeManager.get(DocTree.class)));
    }

    private Mono<ServerResponse> updateVersion(ServerRequest request) {
        String versionName = request.pathVariable("name");
        return this.checkPermission(versionName, Project.PermissionLevel.ADMIN).then(this.extensionHandler.handleUpdate(request, this.schemeManager.get(ProjectVersion.class)));
    }

    private Mono<ServerResponse> listSupportedLanguages(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.docTreeLister.listAllLanguagesUnderVersion(name).map(docTree -> new Language().setLabel(docTree.getSpec().getTitle()).setLanguage(docTree.getSpec().getSlug()).setLink(docTree.getStatus().getPermalink())).collectList().flatMap(language -> ServerResponse.ok().bodyValue(language));
    }

    private Mono<ServerResponse> listDocTreeByVersion(ServerRequest request) {
        String versionName = request.pathVariable("name");
        return this.checkPermission(versionName, Project.PermissionLevel.READ).then(this.docTreeLister.listByVersion(versionName).collectList().flatMap(trees -> ServerResponse.ok().bodyValue(trees)));
    }

    private Mono<Void> checkPermission(String versionName, Project.PermissionLevel permissionLevel) {
        return this.client.get(ProjectVersion.class, versionName).flatMap(version -> {
            String projectName = version.getSpec().getProjectName();
            return this.client.get(Project.class, projectName);
        }).flatMap(project -> this.projectPermissionService.checkPermission((Project)((Object)project), permissionLevel));
    }

    public GroupVersion groupVersion() {
        return GroupVersion.parseAPIVersion((String)"api.uc.doc.halo.run/v1alpha1");
    }

    @Generated
    public ProjectVersionEndpoint(DocTreeLister docTreeLister, ReactiveExtensionClient client, ExtensionHandler extensionHandler, ProjectPermissionService projectPermissionService, SchemeManager schemeManager) {
        this.docTreeLister = docTreeLister;
        this.client = client;
        this.extensionHandler = extensionHandler;
        this.projectPermissionService = projectPermissionService;
        this.schemeManager = schemeManager;
    }
}

