/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.endpoint;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.springdoc.core.fn.builders.apiresponse.Builder;
import org.springdoc.webflux.core.fn.SpringdocRouteBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import run.halo.app.core.extension.endpoint.CustomEndpoint;
import run.halo.app.extension.GroupVersion;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.Scheme;
import run.halo.app.extension.SchemeManager;
import run.halo.app.extension.router.SortableRequest;
import run.halo.doc.endpoint.ExtensionHandler;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.model.Language;
import run.halo.doc.service.DocTreeLister;
import run.halo.doc.service.ProjectPermissionService;
import run.halo.doc.service.ProjectVersionLister;
import run.halo.doc.utils.MarkdownUtils;

@Component
public class ProjectEndpoint
implements CustomEndpoint {
    private final ProjectVersionLister projectVersionLister;
    private final DocTreeLister docTreeLister;
    private final ReactiveExtensionClient client;
    private final ProjectPermissionService projectPermissionService;
    private final ExtensionHandler extensionHandler;
    private final SchemeManager schemeManager;

    public RouterFunction<ServerResponse> endpoint() {
        String tag = "api.uc.doc.halo.run/v1alpha1/Project";
        return SpringdocRouteBuilder.route().GET("projects/{name}/languages", this::listSupportedLanguages, builder -> builder.operationId("ListSupportedLanguagesByProject").description("List all supported languages by project").tag("api.uc.doc.halo.run/v1alpha1/Project").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementationArray(Language.class))).GET("projects/{name}/versions", this::listProjectVersions, builder -> builder.operationId("ListProjectVersions").description("List all versions of a project").tag("api.uc.doc.halo.run/v1alpha1/Project").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementationArray(ProjectVersion.class))).POST("projects/{name}/versions", this::createVersion, builder -> builder.operationId("CreateProjectVersion").description("Create a project version").tag("api.uc.doc.halo.run/v1alpha1/Project").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().implementation(ProjectVersion.class)).response(Builder.responseBuilder().implementation(ProjectVersion.class))).GET("projects", this::listProjects, builder -> builder.operationId("ListProjects").description("List all projects").tag("api.uc.doc.halo.run/v1alpha1/Project").response(Builder.responseBuilder().implementationArray(Project.class))).GET("projects/{name}", this::getProject, builder -> builder.operationId("GetProject").description("Get a project").tag("api.uc.doc.halo.run/v1alpha1/Project").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementation(Project.class))).POST("projects/{name}/markdown", this::renderMarkdown, builder -> builder.operationId("RenderMarkdown").description("Render markdown content under a project").tag("api.uc.doc.halo.run/v1alpha1/Project").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().implementation(MarkdownRequest.class)).response(Builder.responseBuilder().implementation(String.class))).PUT("projects/{name}", this::updateProject, builder -> builder.operationId("UpdateProject").description("Update a project").tag("api.uc.doc.halo.run/v1alpha1/Project").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().implementation(Project.class)).response(Builder.responseBuilder().implementation(Project.class))).PATCH("projects/{name}", this::pathProject, builder -> ExtensionHandler.buildPatchApiDoc(builder, "api.uc.doc.halo.run/v1alpha1/Project", Scheme.buildFromType(Project.class))).POST("projects", this::createProject, builder -> builder.operationId("CreateProject").description("Create a project").tag("api.uc.doc.halo.run/v1alpha1/Project").requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().implementation(Project.class)).response(Builder.responseBuilder().implementation(Project.class))).DELETE("projects/{name}", this::deleteProject, builder -> builder.operationId("DeleteProject").description("Delete a project").tag("api.uc.doc.halo.run/v1alpha1/Project").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementation(Project.class))).build();
    }

    private Mono<ServerResponse> renderMarkdown(ServerRequest request) {
        return this.getProjectWithPermissionCheck(request.pathVariable("name"), Project.PermissionLevel.READ).flatMap(proj -> request.bodyToMono(MarkdownRequest.class).map(markdownReq -> MarkdownUtils.renderMarkdown(markdownReq.markdown())).flatMap(html -> ServerResponse.ok().bodyValue(html)));
    }

    private Mono<ServerResponse> getProject(ServerRequest request) {
        return this.getProjectWithPermissionCheck(request.pathVariable("name"), Project.PermissionLevel.READ).flatMap(project -> ServerResponse.ok().bodyValue((Object)project));
    }

    private Mono<ServerResponse> createVersion(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.getProjectWithPermissionCheck(name, Project.PermissionLevel.ADMIN).flatMap(project -> this.extensionHandler.handleCreate(request, this.schemeManager.get(ProjectVersion.class)));
    }

    private Mono<ServerResponse> pathProject(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.getProjectWithPermissionCheck(name, Project.PermissionLevel.ADMIN).flatMap(existing -> this.extensionHandler.handlePatch(request, this.schemeManager.get(Project.class)));
    }

    private Mono<ServerResponse> deleteProject(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.getProjectWithPermissionCheck(name, Project.PermissionLevel.ADMIN).flatMap(existing -> this.extensionHandler.handleDelete(request, this.schemeManager.get(Project.class)));
    }

    private Mono<ServerResponse> createProject(ServerRequest request) {
        return this.extensionHandler.handleCreate(request, this.schemeManager.get(Project.class));
    }

    private Mono<ServerResponse> updateProject(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.getProjectWithPermissionCheck(name, Project.PermissionLevel.ADMIN).flatMap(existing -> this.extensionHandler.handleUpdate(request, this.schemeManager.get(Project.class)));
    }

    private Mono<Project> getProjectWithPermissionCheck(String name, Project.PermissionLevel requiredPermission) {
        return this.client.get(Project.class, name).flatMap(existing -> this.projectPermissionService.checkPermission((Project)((Object)existing), requiredPermission).thenReturn((Object)existing));
    }

    private Mono<ServerResponse> listProjectVersions(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.listProjectVersions(name).collectList().flatMap(versions -> ServerResponse.ok().bodyValue(versions));
    }

    private Flux<ProjectVersion> listProjectVersions(String projectName) {
        return this.projectPermissionService.checkPermission(projectName, Project.PermissionLevel.READ).thenMany(this.projectVersionLister.listByProjectName(projectName));
    }

    private Mono<ServerResponse> listProjects(ServerRequest serverRequest) {
        SortableRequest query = new SortableRequest(serverRequest.exchange());
        return this.client.listAll(Project.class, query.toListOptions(), query.getSort()).filterWhen(project -> this.projectPermissionService.hasPermission((Project)((Object)project), Project.PermissionLevel.READ)).collectList().flatMap(list -> ServerResponse.ok().bodyValue(list));
    }

    private Mono<ServerResponse> listSupportedLanguages(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.projectPermissionService.checkPermission(name, Project.PermissionLevel.READ).then(this.listSupportedLanguages(name)).flatMap(languages -> ServerResponse.ok().bodyValue(languages));
    }

    private Mono<List<Language>> listSupportedLanguages(String name) {
        return this.projectVersionLister.listByProjectName(name).flatMap(version -> this.docTreeLister.listAllLanguagesUnderVersion(version.getMetadata().getName())).map(docTree -> new Language().setLabel(docTree.getSpec().getTitle()).setLanguage(docTree.getSpec().getSlug()).setLink(docTree.getStatus().getPermalink())).sort(Comparator.comparing(Language::getLanguage)).distinct(Language::getLanguage).collectList();
    }

    public GroupVersion groupVersion() {
        return GroupVersion.parseAPIVersion((String)"api.uc.doc.halo.run/v1alpha1");
    }

    @Generated
    public ProjectEndpoint(ProjectVersionLister projectVersionLister, DocTreeLister docTreeLister, ReactiveExtensionClient client, ProjectPermissionService projectPermissionService, ExtensionHandler extensionHandler, SchemeManager schemeManager) {
        this.projectVersionLister = projectVersionLister;
        this.docTreeLister = docTreeLister;
        this.client = client;
        this.projectPermissionService = projectPermissionService;
        this.extensionHandler = extensionHandler;
        this.schemeManager = schemeManager;
    }

    public record MarkdownRequest(String markdown) {
    }
}

