/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.endpoint;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class JsonPatch {
    public static final String SCHEMA_NAME = "JsonPatch";

    private JsonPatch() {
    }

    public static void addSchema(Components components) {
        Function<String, Schema> opSchemaFunc = op -> new StringSchema()._enum(List.of(op)).type("string");
        Schema pathSchema = new StringSchema().description("A JSON Pointer path").pattern("^(/[^/~]*(~[01][^/~]*)*)*$").example((Object)"/a/b/c");
        Schema valueSchema = new Schema().description("Value can be any JSON value");
        Schema operationSchema = new Schema().oneOf(List.of(new Schema().$ref("#/components/schemas/AddOperation"), new Schema().$ref("#/components/schemas/ReplaceOperation"), new Schema().$ref("#/components/schemas/TestOperation"), new Schema().$ref("#/components/schemas/RemoveOperation"), new Schema().$ref("#/components/schemas/MoveOperation"), new Schema().$ref("#/components/schemas/CopyOperation")));
        components.addSchemas("AddOperation", new ObjectSchema().required(List.of("op", "path", "value")).properties(Map.of("op", opSchemaFunc.apply("add"), "path", pathSchema, "value", valueSchema)));
        components.addSchemas("ReplaceOperation", new ObjectSchema().required(List.of("op", "path", "value")).properties(Map.of("op", opSchemaFunc.apply("replace"), "path", pathSchema, "value", valueSchema)));
        components.addSchemas("TestOperation", new ObjectSchema().required(List.of("op", "path", "value")).properties(Map.of("op", opSchemaFunc.apply("test"), "path", pathSchema, "value", valueSchema)));
        components.addSchemas("RemoveOperation", new ObjectSchema().required(List.of("op", "path")).properties(Map.of("op", opSchemaFunc.apply("remove"), "path", pathSchema)));
        components.addSchemas("MoveOperation", new ObjectSchema().required(List.of("op", "from", "path")).properties(Map.of("op", opSchemaFunc.apply("move"), "from", pathSchema.description("A JSON Pointer path pointing to the location to move/copy from."), "path", pathSchema)));
        components.addSchemas("CopyOperation", new ObjectSchema().required(List.of("op", "from", "path")).properties(Map.of("op", opSchemaFunc.apply("copy"), "from", pathSchema.description("A JSON Pointer path pointing to the location to move/copy from."), "path", pathSchema)));
        components.addSchemas(SCHEMA_NAME, new ArraySchema().description("JSON schema for JSONPatch operations").uniqueItems(Boolean.valueOf(true)).minItems(Integer.valueOf(1)).items(operationSchema));
    }
}

