/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.endpoint;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springdoc.core.fn.builders.content.Builder;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Mono;
import run.halo.app.extension.Extension;
import run.halo.app.extension.GroupVersionKind;
import run.halo.app.extension.JsonExtension;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.Scheme;
import run.halo.app.extension.Unstructured;
import run.halo.doc.infra.ExtensionConvertException;

@Component
public class ExtensionHandler {
    private static final MediaType JSON_PATCH_MEDIA_TYPE = MediaType.valueOf((String)"application/json-patch+json");
    private final ReactiveExtensionClient client;

    public static void buildPatchApiDoc(org.springdoc.core.fn.builders.operation.Builder builder, String tagName, Scheme scheme) {
        GroupVersionKind gvk = scheme.groupVersionKind();
        String kind = gvk.kind();
        builder.operationId("patch" + kind).description("Patch " + kind).tag(tagName).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").description("Name of " + scheme.singular())).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().content(Builder.contentBuilder().mediaType("application/json-patch+json").schema(org.springdoc.core.fn.builders.schema.Builder.schemaBuilder().ref(RefUtils.constructRef((String)"JsonPatch"))))).response(org.springdoc.core.fn.builders.apiresponse.Builder.responseBuilder().responseCode("200").description("Response " + scheme.singular() + " patched just now").implementation(scheme.type()));
    }

    public Mono<ServerResponse> handleCreate(@NonNull ServerRequest request, Scheme scheme) {
        return request.bodyToMono(Unstructured.class).switchIfEmpty(Mono.error((Throwable)((Object)new ExtensionConvertException("Cannot read body to " + String.valueOf(scheme.groupVersionKind()))))).flatMap(arg_0 -> ((ReactiveExtensionClient)this.client).create(arg_0)).flatMap(createdExt -> ServerResponse.created((URI)URI.create("/apis/" + scheme.groupVersionKind().group() + "/" + scheme.groupVersionKind().version() + "/" + scheme.plural() + "/" + createdExt.getMetadata().getName())).contentType(MediaType.APPLICATION_JSON).bodyValue(createdExt));
    }

    Mono<ServerResponse> handleUpdate(ServerRequest request, Scheme scheme) {
        String name = request.pathVariable("name");
        return request.bodyToMono(Unstructured.class).filter(unstructured -> unstructured.getMetadata() != null && StringUtils.hasText((String)unstructured.getMetadata().getName()) && Objects.equals(unstructured.getMetadata().getName(), name)).switchIfEmpty(Mono.error((Throwable)new ServerWebInputException("Cannot read body to " + String.valueOf(scheme.groupVersionKind())))).flatMap(arg_0 -> ((ReactiveExtensionClient)this.client).update(arg_0)).flatMap(updated -> ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).bodyValue(updated));
    }

    public Mono<ServerResponse> handleDelete(ServerRequest request, Scheme scheme) {
        String name = request.pathVariable("name");
        return this.client.get(scheme.type(), name).flatMap(arg_0 -> ((ReactiveExtensionClient)this.client).delete(arg_0)).flatMap(deleted -> ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).bodyValue(deleted));
    }

    public Mono<ServerResponse> handlePatch(ServerRequest request, Scheme scheme) {
        String name = request.pathVariable("name");
        Optional contentTypeOpt = request.headers().contentType();
        if (contentTypeOpt.isEmpty()) {
            return Mono.error((Throwable)new UnsupportedMediaTypeStatusException((MediaType)null, List.of(JSON_PATCH_MEDIA_TYPE)));
        }
        MediaType contentType = (MediaType)contentTypeOpt.get();
        if (!contentType.isCompatibleWith(JSON_PATCH_MEDIA_TYPE)) {
            return Mono.error((Throwable)new UnsupportedMediaTypeStatusException(contentType, List.of(JSON_PATCH_MEDIA_TYPE)));
        }
        return request.bodyToMono(JsonPatch.class).switchIfEmpty(Mono.error((Throwable)new ServerWebInputException("Request body required."))).flatMap(jsonPatch -> this.client.getJsonExtension(scheme.groupVersionKind(), name).flatMap(jsonExtension -> {
            try {
                ObjectNode appliedJsonNode = (ObjectNode)jsonPatch.apply((JsonNode)jsonExtension.getInternal());
                JsonExtension patchedExtension = new JsonExtension(jsonExtension.getObjectMapper(), appliedJsonNode);
                return this.client.update((Extension)patchedExtension);
            }
            catch (JsonPatchException e) {
                return Mono.error((Throwable)e);
            }
        })).flatMap(updated -> ServerResponse.ok().bodyValue(updated));
    }

    @Generated
    public ExtensionHandler(ReactiveExtensionClient client) {
        this.client = client;
    }
}

