/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.endpoint;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import lombok.Generated;
import org.springdoc.core.fn.builders.apiresponse.Builder;
import org.springdoc.webflux.core.fn.SpringdocRouteBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;
import run.halo.app.core.extension.endpoint.CustomEndpoint;
import run.halo.app.extension.GroupVersion;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.Scheme;
import run.halo.app.extension.SchemeManager;
import run.halo.doc.endpoint.ExtensionHandler;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.service.ProjectPermissionService;

@Component
public class DocTreeEndpoint
implements CustomEndpoint {
    private final ReactiveExtensionClient client;
    private final ExtensionHandler extensionHandler;
    private final ProjectPermissionService projectPermissionService;
    private final SchemeManager schemeManager;

    public RouterFunction<ServerResponse> endpoint() {
        String tag = "api.uc.doc.halo.run/v1alpha1/DocTree";
        return SpringdocRouteBuilder.route().GET("doctrees/{name}", this::getDocTree, builder -> builder.operationId("GetDocTree").description("Get doc tree by name").tag("api.uc.doc.halo.run/v1alpha1/DocTree").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementation(DocTree.class))).PUT("doctrees/{name}", this::updateDocTree, builder -> builder.operationId("UpdateDocTree").description("Update doc tree by name").tag("api.uc.doc.halo.run/v1alpha1/DocTree").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().implementation(DocTree.class)).response(Builder.responseBuilder().implementation(DocTree.class))).PATCH("doctrees/{name}", this::pathDocTree, builder -> ExtensionHandler.buildPatchApiDoc(builder, "api.uc.doc.halo.run/v1alpha1/DocTree", Scheme.buildFromType(DocTree.class))).DELETE("doctrees/{name}", this::deleteDocTree, builder -> builder.operationId("DeleteDocTree").description("Delete doc tree by name").tag("api.uc.doc.halo.run/v1alpha1/DocTree").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().responseCode("204").implementation(Void.class))).build();
    }

    private Mono<ServerResponse> pathDocTree(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.getProjectBy(name).flatMap(project -> this.projectPermissionService.checkPermission((Project)((Object)project), Project.PermissionLevel.WRITE).thenReturn((Object)project)).then(this.extensionHandler.handlePatch(request, this.schemeManager.get(DocTree.class)));
    }

    private Mono<ServerResponse> deleteDocTree(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.getProjectBy(name).flatMap(project -> this.projectPermissionService.checkPermission((Project)((Object)project), Project.PermissionLevel.WRITE).thenReturn((Object)project)).then(this.extensionHandler.handleDelete(request, this.schemeManager.get(DocTree.class)));
    }

    private Mono<ServerResponse> getDocTree(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.getProjectBy(name).flatMap(project -> this.projectPermissionService.checkPermission((Project)((Object)project), Project.PermissionLevel.READ).thenReturn((Object)project)).then(this.client.get(DocTree.class, name)).flatMap(docTree -> ServerResponse.ok().bodyValue((Object)docTree));
    }

    private Mono<ServerResponse> updateDocTree(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.getProjectBy(name).flatMap(project -> this.projectPermissionService.checkPermission((Project)((Object)project), Project.PermissionLevel.WRITE).thenReturn((Object)project)).then(this.extensionHandler.handleUpdate(request, this.schemeManager.get(DocTree.class)));
    }

    private Mono<Project> getProjectBy(String docTreeName) {
        return this.client.fetch(DocTree.class, docTreeName).flatMap(docTree -> this.client.get(ProjectVersion.class, docTree.getSpec().getProjectVersionName()).map(version -> version.getSpec().getProjectName()).flatMap(projectName -> this.client.get(Project.class, projectName)));
    }

    public GroupVersion groupVersion() {
        return new GroupVersion("api.uc.doc.halo.run", "v1alpha1");
    }

    @Generated
    public DocTreeEndpoint(ReactiveExtensionClient client, ExtensionHandler extensionHandler, ProjectPermissionService projectPermissionService, SchemeManager schemeManager) {
        this.client = client;
        this.extensionHandler = extensionHandler;
        this.projectPermissionService = projectPermissionService;
        this.schemeManager = schemeManager;
    }
}

