/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.theme;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import run.halo.app.extension.ConfigMap;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionClient;
import run.halo.app.extension.Metadata;
import run.halo.app.extension.MetadataOperator;
import run.halo.app.infra.utils.JsonUtils;
import run.halo.doc.model.DocTreeIdentity;

@Component
public class DocTreeRouteMap
extends ConcurrentHashMap<String, DocTreeIdentity>
implements InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocTreeRouteMap.class);
    public static final String STORE_CONFIGMAP = "doc-tree-route-map.docsme.halo.run";
    static final String STORE_KEY = "doc-tree-route-map.json";
    private final ExtensionClient client;

    public void destroy() throws Exception {
        Map<String, String> data = Map.of(STORE_KEY, JsonUtils.objectToJson((Object)this));
        Optional configMapOptional = this.client.fetch(ConfigMap.class, STORE_CONFIGMAP);
        if (configMapOptional.isEmpty()) {
            ConfigMap configMap = new ConfigMap();
            configMap.setMetadata((MetadataOperator)new Metadata());
            configMap.getMetadata().setName(STORE_CONFIGMAP);
            configMap.setData(data);
            this.client.create((Extension)configMap);
            return;
        }
        ConfigMap configMap = (ConfigMap)configMapOptional.get();
        configMap.setData(data);
        this.client.update((Extension)configMap);
        this.clear();
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.client.fetch(ConfigMap.class, STORE_CONFIGMAP).ifPresent(configMap -> {
                Map data = configMap.getData();
                if (data == null) {
                    return;
                }
                this.putAll(this.load(data));
            });
        }
        catch (Exception e) {
            log.debug("Failed to load doc tree route map from config map: [{}]", (Object)STORE_CONFIGMAP);
        }
    }

    Map<String, DocTreeIdentity> load(Map<String, String> data) {
        String json = data.get(STORE_KEY);
        if (StringUtils.isBlank((CharSequence)json)) {
            return Map.of();
        }
        return (Map)JsonUtils.jsonToObject((String)json, (TypeReference)new TypeReference<Map<String, DocTreeIdentity>>(){});
    }

    @Generated
    public DocTreeRouteMap(ExtensionClient client) {
        this.client = client;
    }
}

