/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.theme;

import lombok.Generated;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;
import run.halo.doc.model.DocTreeIdentity;
import run.halo.doc.service.DocTreeService;
import run.halo.doc.theme.DocTreeRequestHandler;
import run.halo.doc.theme.DocTreeRouteMap;

@Component
public class DocTreeCompositeRouterFunction
implements RouterFunction<ServerResponse> {
    private static final PathPattern DOC_PATTERN = PathPatternParser.defaultInstance.parse("/docs/{projectSlug}/{*otherParts}");
    private final DocTreeRequestHandler docTreeRequestHandler;
    private final DocTreeRouteMap docTreeRouteMap;
    private final DocTreeService docTreeService;

    @NonNull
    public Mono<HandlerFunction<ServerResponse>> route(ServerRequest request) {
        String path = request.path();
        PathContainer pathContainer = PathContainer.parsePath((String)path);
        if (!DOC_PATTERN.matches(pathContainer)) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            DocTreeIdentity identity = (DocTreeIdentity)this.docTreeRouteMap.get(path);
            if (identity == null || identity.isMarkedAsLanguage()) {
                return this.docTreeService.findFirstPage(path).map(this::docTreeHandler).switchIfEmpty(Mono.empty());
            }
            String docTreeName = identity.getName();
            return Mono.just(this.docTreeHandler(docTreeName));
        });
    }

    HandlerFunction<ServerResponse> docTreeHandler(String docTreeName) {
        return request -> this.docTreeRequestHandler.handle(request, docTreeName);
    }

    @Generated
    public DocTreeCompositeRouterFunction(DocTreeRequestHandler docTreeRequestHandler, DocTreeRouteMap docTreeRouteMap, DocTreeService docTreeService) {
        this.docTreeRequestHandler = docTreeRequestHandler;
        this.docTreeRouteMap = docTreeRouteMap;
        this.docTreeService = docTreeService;
    }
}

