/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.theme;

import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import run.halo.app.content.comment.CommentSubject;
import run.halo.app.extension.GroupVersionKind;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.Ref;
import run.halo.app.infra.ExternalLinkProcessor;
import run.halo.doc.extensions.DocTree;

@Component
public class DocCommentSubject
implements CommentSubject<DocTree> {
    private final ReactiveExtensionClient client;
    private final ExternalLinkProcessor externalLinkProcessor;

    public Mono<DocTree> get(String name) {
        return this.client.fetch(DocTree.class, name);
    }

    public Mono<CommentSubject.SubjectDisplay> getSubjectDisplay(String name) {
        return this.get(name).map(tree -> new CommentSubject.SubjectDisplay(tree.getSpec().getTitle(), this.externalLinkProcessor.processLink(tree.getStatus().getPermalink()), "\u6587\u6863"));
    }

    public boolean supports(Ref ref) {
        Assert.notNull((Object)ref, (String)"Subject ref must not be null.");
        GroupVersionKind groupVersionKind = new GroupVersionKind(ref.getGroup(), ref.getVersion(), ref.getKind());
        return GroupVersionKind.fromExtension(DocTree.class).equals((Object)groupVersionKind);
    }

    @Generated
    public DocCommentSubject(ReactiveExtensionClient client, ExternalLinkProcessor externalLinkProcessor) {
        this.client = client;
        this.externalLinkProcessor = externalLinkProcessor;
    }
}

