/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.service.impl;

import lombok.Generated;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import run.halo.app.extension.ListOptions;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.index.query.Query;
import run.halo.app.extension.index.query.QueryFactory;
import run.halo.app.extension.router.selector.FieldSelector;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.service.ProjectVersionLister;

@Component
public class ProjectVersionListerImpl
implements ProjectVersionLister {
    private final ReactiveExtensionClient client;

    @Override
    public Flux<ProjectVersion> listByProjectName(String projectName) {
        ListOptions listOptions = new ListOptions();
        listOptions.setFieldSelector(FieldSelector.of((Query)QueryFactory.equal((String)"spec.projectName", (String)projectName)));
        return this.client.listAll(ProjectVersion.class, listOptions, this.defaultSort());
    }

    @Override
    public Flux<ProjectVersion> getByProjectNameAndVersionSlug(String projectName, String versionSlug) {
        ListOptions listOptions = new ListOptions();
        listOptions.setFieldSelector(FieldSelector.of((Query)QueryFactory.and((Query)QueryFactory.equal((String)"spec.projectName", (String)projectName), (Query)QueryFactory.equal((String)"spec.slug", (String)versionSlug))));
        return this.client.listAll(ProjectVersion.class, listOptions, this.defaultSort());
    }

    Sort defaultSort() {
        return Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"metadata.creationTimestamp"), Sort.Order.asc((String)"metadata.name")});
    }

    @Generated
    public ProjectVersionListerImpl(ReactiveExtensionClient client) {
        this.client = client;
    }
}

