/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.service.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.util.Predicates;
import org.springframework.http.server.PathContainer;
import org.springframework.stereotype.Component;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.infra.NotFoundException;
import run.halo.doc.model.DocTreeDetail;
import run.halo.doc.model.DocTreeNode;
import run.halo.doc.model.DocWithContent;
import run.halo.doc.model.Language;
import run.halo.doc.model.ProjectVersionSorter;
import run.halo.doc.service.DocService;
import run.halo.doc.service.DocTreeLister;
import run.halo.doc.service.DocTreeService;
import run.halo.doc.service.ProjectGetter;
import run.halo.doc.service.ProjectPermissionService;
import run.halo.doc.service.ProjectVersionLister;
import run.halo.doc.utils.DocTreeNodeUtils;
import run.halo.doc.utils.NaryTreeWalker;

@Component
public class DocTreeServiceImpl
implements DocTreeService {
    private static final PathPattern DOC_PATTERN = PathPatternParser.defaultInstance.parse("/docs/{projectSlug}/{*otherParts}");
    private final ReactiveExtensionClient client;
    private final DocService docService;
    private final ProjectVersionLister projectVersionLister;
    private final DocTreeLister docTreeLister;
    private final ProjectGetter projectGetter;
    private final ProjectPermissionService projectPermissionService;

    @Override
    public Mono<DocTreeDetail> getByName(String docTreeName, boolean onlyPublished) {
        return this.client.get(DocTree.class, docTreeName).filter(onlyPublished ? DocTree::isPublished : Predicates.isTrue()).switchIfEmpty(Mono.error((Throwable)((Object)new NotFoundException("No doc resource found.")))).flatMap(docTree -> {
            DocTreeDetail docTreeDetail = new DocTreeDetail().setDocTree((DocTree)((Object)docTree));
            String versionName = docTree.getSpec().getProjectVersionName();
            ArrayList<Object> publishers = new ArrayList<Object>();
            if (DocTree.isDoc(docTree)) {
                Mono docInfoMono = this.getContentForDoc((DocTree)((Object)docTree), onlyPublished).doOnNext(docTreeDetail::setDocInfo).thenReturn((Object)docTree);
                publishers.add(docInfoMono);
            }
            Mono joinVersionMono = this.client.get(ProjectVersion.class, versionName).filter(onlyPublished ? ProjectVersion::isPublished : Predicates.isTrue()).switchIfEmpty(Mono.error((Throwable)((Object)new NotFoundException("Project version not found.")))).doOnNext(docTreeDetail::setCurrentVersion);
            Mono<List<DocTreeNode>> joinTreeListMono = this.populateTreeAndLanguage(docTreeName, versionName, docTreeDetail, onlyPublished);
            publishers.add(joinVersionMono);
            publishers.add(joinTreeListMono);
            return Mono.when(publishers).thenReturn((Object)docTreeDetail);
        }).flatMap(docTreeDetail -> {
            String projectName = docTreeDetail.getCurrentVersion().getSpec().getProjectName();
            return this.client.get(Project.class, projectName).doOnNext(docTreeDetail::setProject).thenReturn(docTreeDetail);
        }).flatMap(docTreeDetail -> {
            String projectName = docTreeDetail.getCurrentVersion().getSpec().getProjectName();
            return this.projectVersionLister.listByProjectName(projectName).filter(onlyPublished ? ProjectVersion::isPublished : Predicates.isTrue()).collectList().map(versions -> ProjectVersionSorter.of(versions).sortedVersions()).doOnNext(docTreeDetail::setVersions).thenReturn(docTreeDetail);
        });
    }

    private Mono<DocWithContent> getContentForDoc(DocTree docTree, boolean onlyPublished) {
        if (onlyPublished) {
            return this.docService.getPublishedByName(docTree.getSpec().getDocName());
        }
        return this.docService.getByName(docTree.getSpec().getDocName());
    }

    private Mono<List<DocTreeNode>> populateTreeAndLanguage(String docTreeName, String versionName, DocTreeDetail docTreeDetail, boolean onlyPublished) {
        return this.docTreeLister.listByVersion(versionName).filter(onlyPublished ? DocTree::isPublished : Predicates.isTrue()).map(node -> new DocTreeNode().setMetadata(node.getMetadata()).setSpec(node.getSpec()).setStatus(node.getStatus())).collectList().doOnNext(treeList -> {
            Map<String, DocTreeNode> langNodeMap = DocTreeNodeUtils.getNameLanguageNodeMap(treeList);
            NaryTreeWalker<DocTreeNode> naryTreeWalker = NaryTreeWalker.of(treeList);
            DocTreeNode langNode = this.computeCurrentLanguage(docTreeName, naryTreeWalker, langNodeMap);
            if (langNode != null) {
                Language language = new Language().setLabel(langNode.getSpec().getTitle()).setLanguage(langNode.getSpec().getSlug()).setLink(langNode.getStatus().getPermalink());
                docTreeDetail.setCurrentLanguage(language);
            }
            List<Language> languages = langNodeMap.values().stream().map(node -> new Language().setLabel(node.getSpec().getTitle()).setLanguage(node.getSpec().getSlug()).setLink(node.getStatus().getPermalink())).toList();
            docTreeDetail.setLanguages(languages);
            List<DocTreeNode> sortedTree = naryTreeWalker.sortBy(DocTreeNodeUtils.treeNodeComparator());
            if (langNode != null) {
                List<DocTreeNode> subTree = sortedTree.stream().filter(rootNode -> langNode.getMetadata().getName().equals(rootNode.getMetadata().getName())).findFirst().map(NaryTreeWalker.TreeNode::getChildren).orElse(List.of());
                docTreeDetail.setDocTrees(subTree);
            } else {
                docTreeDetail.setDocTrees(sortedTree);
            }
        });
    }

    DocTreeNode computeCurrentLanguage(String currentNodeName, NaryTreeWalker<DocTreeNode> naryTreeWalker, Map<String, DocTreeNode> langNodeMap) {
        List<DocTreeNode> pathTokenList = naryTreeWalker.computeNodePath((DocTreeNode)((Object)currentNodeName));
        if (pathTokenList.isEmpty()) {
            return null;
        }
        String firstToken = (String)((Object)pathTokenList.get(0));
        if (!langNodeMap.containsKey(firstToken)) {
            return null;
        }
        return langNodeMap.get(firstToken);
    }

    @Override
    public Mono<String> findFirstPage(String path) {
        PathContainer pathContainer = PathContainer.parsePath((String)path);
        PathPattern.PathMatchInfo matchResult = DOC_PATTERN.matchAndExtract(pathContainer);
        if (matchResult == null) {
            return Mono.empty();
        }
        String projectSlug = (String)matchResult.getUriVariables().get("projectSlug");
        if (StringUtils.isBlank((CharSequence)projectSlug)) {
            return Mono.empty();
        }
        List<String> pathSegments = this.parsePathSegments((String)matchResult.getUriVariables().get("otherParts"));
        return this.projectGetter.getBySlug(projectSlug).flatMap(this::checkReadPermission).flatMap(project -> this.resolveVersion((Project)((Object)project), pathSegments)).flatMap(this::handleFallback);
    }

    @Override
    public Mono<DocTree> getFirstDocTree(String versionName, String langSlug) {
        return this.findFirstNode(versionName, langSlug).map(node -> {
            DocTree newDocTree = new DocTree();
            newDocTree.setMetadata(node.getMetadata());
            newDocTree.setSpec(node.getSpec());
            newDocTree.setStatus(node.getStatus());
            return newDocTree;
        });
    }

    private Mono<DocTreeNode> getFirstDocPageNode(String versionName, String langSlug) {
        return this.findFirstNode(versionName, langSlug).mapNotNull(this::findFirstDocNode);
    }

    private Mono<DocTreeNode> findFirstNode(String versionName, String langSlug) {
        return this.docTreeLister.listByVersion(versionName).filter(DocTree::isPublished).map(node -> new DocTreeNode().setMetadata(node.getMetadata()).setSpec(node.getSpec()).setStatus(node.getStatus())).collectList().mapNotNull(nodeList -> {
            if (nodeList.isEmpty()) {
                return null;
            }
            Map<String, DocTreeNode> langNodeMap = DocTreeNodeUtils.getSlugLanguageNodeMap(nodeList);
            String languageNodeName = null;
            if (StringUtils.isNotBlank((CharSequence)langSlug)) {
                DocTreeNode languageNode = langNodeMap.get(langSlug);
                if (languageNode == null) {
                    return null;
                }
                languageNodeName = languageNode.getMetadata().getName();
            }
            String resolvedLanguageName = languageNodeName;
            NaryTreeWalker<DocTreeNode> naryTreeWalker = NaryTreeWalker.of(nodeList);
            List<DocTreeNode> sortedTree = naryTreeWalker.sortBy(DocTreeNodeUtils.treeNodeComparator());
            if (resolvedLanguageName == null) {
                return sortedTree.get(0);
            }
            return sortedTree.stream().filter(rootNode -> resolvedLanguageName.equals(rootNode.getMetadata().getName())).findFirst().map(node -> (DocTreeNode)Iterables.getFirst(node.getChildren(), null)).orElse(null);
        });
    }

    private DocTreeNode findFirstDocNode(DocTreeNode node) {
        if (node == null) {
            return null;
        }
        if (DocTree.Type.DOC.equals((Object)node.getSpec().getType())) {
            return node;
        }
        if (DocTree.Type.TREE.equals((Object)node.getSpec().getType()) && node.getChildren() != null) {
            DocTreeNode firstChild = (DocTreeNode)Iterables.getFirst(node.getChildren(), null);
            return this.findFirstDocNode(firstChild);
        }
        return null;
    }

    private Mono<Project> checkReadPermission(Project project) {
        if (project.getSpec().isAuthorizeRequired()) {
            return this.projectPermissionService.checkPermission(project, Project.PermissionLevel.READ).thenReturn((Object)project);
        }
        return Mono.just((Object)((Object)project));
    }

    private Mono<VersionResolution> resolveVersion(Project project, List<String> pathSegments) {
        String projectName = project.getMetadata().getName();
        if (!pathSegments.isEmpty()) {
            String candidateVersionSlug = pathSegments.get(0);
            return this.projectVersionLister.getByProjectNameAndVersionSlug(projectName, candidateVersionSlug).filter(ProjectVersion::isPublished).next().map(version -> new VersionResolution(version.getMetadata().getName(), this.copySubList(pathSegments, 1), project.getSpec().getPreferredLanguage())).switchIfEmpty(this.resolvePreferredVersion(project).map(versionName -> new VersionResolution((String)versionName, this.copySubList(pathSegments, 0), project.getSpec().getPreferredLanguage())));
        }
        return this.resolvePreferredVersion(project).map(versionName -> new VersionResolution((String)versionName, List.of(), project.getSpec().getPreferredLanguage()));
    }

    private Mono<String> resolvePreferredVersion(Project project) {
        Project.VersionRef versionRef = project.getSpec().getPreferredVersionRef();
        if (versionRef == null) {
            return Mono.empty();
        }
        return this.client.get(ProjectVersion.class, versionRef.getName()).filter(ProjectVersion::isPublished).map(version -> version.getMetadata().getName());
    }

    private List<String> parsePathSegments(String otherParts) {
        if (StringUtils.isBlank((CharSequence)otherParts)) {
            return new ArrayList<String>();
        }
        ArrayList<String> segments = new ArrayList<String>();
        for (String segment : otherParts.split("/")) {
            if (!StringUtils.isNotBlank((CharSequence)segment)) continue;
            segments.add(segment);
        }
        return segments;
    }

    private List<String> copySubList(List<String> source, int fromIndex) {
        if (source == null || fromIndex >= source.size()) {
            return List.of();
        }
        return new ArrayList<String>(source.subList(fromIndex, source.size()));
    }

    private Mono<String> handleFallback(VersionResolution resolution) {
        List<String> remainingSegments = resolution.remainingSegments();
        if (remainingSegments.isEmpty()) {
            return this.getFirstDocPageNode(resolution.versionName(), resolution.preferredLanguage()).map(node -> node.getMetadata().getName());
        }
        String languageSlug = remainingSegments.get(0);
        if (remainingSegments.size() > 1) {
            return Mono.empty();
        }
        return this.getFirstDocPageNode(resolution.versionName(), languageSlug).map(node -> node.getMetadata().getName());
    }

    @Generated
    public DocTreeServiceImpl(ReactiveExtensionClient client, DocService docService, ProjectVersionLister projectVersionLister, DocTreeLister docTreeLister, ProjectGetter projectGetter, ProjectPermissionService projectPermissionService) {
        this.client = client;
        this.docService = docService;
        this.projectVersionLister = projectVersionLister;
        this.docTreeLister = docTreeLister;
        this.projectGetter = projectGetter;
        this.projectPermissionService = projectPermissionService;
    }

    record VersionResolution(String versionName, List<String> remainingSegments, String preferredLanguage) {
    }
}

