/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.service.impl;

import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import run.halo.app.extension.ListOptions;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.index.query.Query;
import run.halo.app.extension.index.query.QueryFactory;
import run.halo.app.extension.router.selector.FieldSelector;
import run.halo.app.extension.router.selector.LabelSelector;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.service.DocTreeLister;

@Component
public class DocTreeListerImpl
implements DocTreeLister {
    private final ReactiveExtensionClient client;

    Sort docTreeSort() {
        return Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"spec.priority"), Sort.Order.asc((String)"metadata.creationTimestamp"), Sort.Order.asc((String)"metadata.name")});
    }

    @Override
    public Flux<DocTree> listByVersion(String versionName) {
        ListOptions listOptions = new ListOptions();
        listOptions.setFieldSelector(FieldSelector.of((Query)QueryFactory.equal((String)"spec.projectVersionName", (String)versionName)));
        return this.client.listAll(DocTree.class, listOptions, this.docTreeSort());
    }

    @Override
    public Flux<DocTree> listAllLanguagesUnderVersion(String versionName) {
        ListOptions listOptions = new ListOptions();
        listOptions.setLabelSelector(LabelSelector.builder().eq("doc.halo.run/marked-as-language", "true").build());
        listOptions.setFieldSelector(FieldSelector.of((Query)QueryFactory.and((Query)QueryFactory.equal((String)"spec.type", (String)DocTree.Type.TREE.name()), (Query)QueryFactory.equal((String)"spec.projectVersionName", (String)versionName))));
        return this.client.listAll(DocTree.class, listOptions, this.docTreeSort());
    }

    @Override
    public Flux<DocTree> listInVersions(List<String> versionNames) {
        ListOptions listOptions = new ListOptions();
        listOptions.setFieldSelector(FieldSelector.of((Query)QueryFactory.in((String)"spec.projectVersionName", versionNames)));
        return this.client.listAll(DocTree.class, listOptions, this.docTreeSort());
    }

    @Generated
    public DocTreeListerImpl(ReactiveExtensionClient client) {
        this.client = client;
    }
}

