/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.service.impl;

import lombok.Generated;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import run.halo.app.core.extension.content.Snapshot;
import run.halo.app.extension.GroupVersionKind;
import run.halo.app.extension.ListOptions;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.Ref;
import run.halo.app.extension.index.query.Query;
import run.halo.app.extension.index.query.QueryFactory;
import run.halo.app.extension.router.selector.FieldSelector;
import run.halo.doc.extensions.Doc;
import run.halo.doc.service.DocSnapshotLister;

@Component
public class DocSnapshotListerImpl
implements DocSnapshotLister {
    private final ReactiveExtensionClient client;

    @Override
    public Flux<Snapshot> listByDocName(String docName) {
        Ref ref = Ref.of((String)docName, (GroupVersionKind)GroupVersionKind.fromExtension(Doc.class));
        ListOptions listOptions = new ListOptions();
        listOptions.setFieldSelector(FieldSelector.of((Query)QueryFactory.equal((String)"spec.subjectRef", (String)Snapshot.toSubjectRefKey((Ref)ref))));
        return this.client.listAll(Snapshot.class, listOptions, this.defaultSort());
    }

    Sort defaultSort() {
        return Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"metadata.creationTimestamp"), Sort.Order.asc((String)"metadata.name")});
    }

    @Generated
    public DocSnapshotListerImpl(ReactiveExtensionClient client) {
        this.client = client;
    }
}

