/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.service;

import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.doc.extensions.Project;
import run.halo.doc.infra.PermissionDeniedException;
import run.halo.doc.service.ProjectPermissionService;
import run.halo.doc.utils.AuthorityUtils;
import run.halo.doc.utils.PrincipalUtils;

@Component
public class ProjectPermissionServiceImpl
implements ProjectPermissionService {
    private final ReactiveExtensionClient client;

    @Override
    public boolean checkPermission(Project project, Project.PermissionLevel requiredPermission, String username, Set<String> roles) {
        if (project.getSpec().getOwner().equals(username)) {
            return true;
        }
        if (AuthorityUtils.containsSuperRole(roles)) {
            return true;
        }
        if (project.getSpec().getMembers() != null) {
            for (Project.ProjectMember member : project.getSpec().getMembers()) {
                if (member.getKind() == Project.MemberType.USER && member.getName().equals(username) && this.hasEnoughPermission(member.getPermission(), requiredPermission)) {
                    return true;
                }
                if (member.getKind() != Project.MemberType.ROLE || !this.userHasRole(member.getName(), roles) || !this.hasEnoughPermission(member.getPermission(), requiredPermission)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Mono<Boolean> hasPermission(Project project, Project.PermissionLevel requiredPermission) {
        return PrincipalUtils.getAuthenticated().map(auth -> this.checkPermission(project, requiredPermission, auth.getName(), PrincipalUtils.convertToRoles(auth))).defaultIfEmpty((Object)false);
    }

    @Override
    public Mono<Void> checkPermission(Project project, Project.PermissionLevel requiredPermission) {
        return PrincipalUtils.getAuthenticated().flatMap(auth -> {
            boolean hasPermission = this.checkPermission(project, requiredPermission, auth.getName(), PrincipalUtils.convertToRoles(auth));
            if (hasPermission) {
                return Mono.empty();
            }
            return Mono.error((Throwable)((Object)new PermissionDeniedException("You do not have permission to " + requiredPermission.name().toLowerCase() + " for this project")));
        });
    }

    @Override
    public Mono<Void> checkPermission(String projectName, Project.PermissionLevel requiredPermission) {
        return this.client.get(Project.class, projectName).flatMap(project -> this.checkPermission((Project)((Object)project), requiredPermission));
    }

    private boolean userHasRole(String roleName, Set<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return false;
        }
        return roles.contains(roleName);
    }

    private boolean hasEnoughPermission(Project.PermissionLevel grantedPermission, Project.PermissionLevel requiredPermission) {
        if (grantedPermission == Project.PermissionLevel.ADMIN) {
            return true;
        }
        if (grantedPermission == Project.PermissionLevel.WRITE) {
            return requiredPermission == Project.PermissionLevel.WRITE || requiredPermission == Project.PermissionLevel.READ;
        }
        if (grantedPermission == Project.PermissionLevel.READ) {
            return requiredPermission == Project.PermissionLevel.READ;
        }
        return false;
    }

    @Generated
    public ProjectPermissionServiceImpl(ReactiveExtensionClient client) {
        this.client = client;
    }
}

