/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.reconciler;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Sort;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import run.halo.app.core.extension.content.Snapshot;
import run.halo.app.extension.AbstractExtension;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionClient;
import run.halo.app.extension.ExtensionOperator;
import run.halo.app.extension.ExtensionUtil;
import run.halo.app.extension.ListOptions;
import run.halo.app.extension.MetadataOperator;
import run.halo.app.extension.MetadataUtil;
import run.halo.app.extension.Ref;
import run.halo.app.extension.controller.Controller;
import run.halo.app.extension.controller.ControllerBuilder;
import run.halo.app.extension.controller.Reconciler;
import run.halo.app.extension.index.query.Query;
import run.halo.app.extension.index.query.QueryFactory;
import run.halo.app.extension.router.selector.FieldSelector;
import run.halo.app.infra.utils.JsonUtils;
import run.halo.doc.extensions.Doc;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.service.DocTreeLister;
import run.halo.doc.utils.DocTreeUtils;

@Component
public class ProjectVersionReconciler
implements Reconciler<Reconciler.Request> {
    static final String FINALIZER = "project-protection";
    private final ExtensionClient client;
    private final DocTreeLister docTreeLister;
    private final RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(5).fixedBackoff(100L).retryOn(OptimisticLockingFailureException.class).build();

    static Doc copyDoc(Doc existingDoc) {
        Doc newDoc = (Doc)((Object)JsonUtils.deepCopy((Object)((Object)existingDoc)));
        String newName = UUID.randomUUID().toString();
        newDoc.getMetadata().setName(newName);
        return newDoc;
    }

    static void updateLabels(ProjectVersion version) {
        Map labels = MetadataUtil.nullSafeLabels((AbstractExtension)version);
        labels.put("doc.halo.run/published", String.valueOf(version.getSpec().isPublish()));
    }

    public Reconciler.Result reconcile(Reconciler.Request request) {
        this.client.fetch(ProjectVersion.class, request.name()).ifPresent(version -> {
            if (ExtensionUtil.isDeleted((ExtensionOperator)version)) {
                if (ExtensionUtil.removeFinalizers((MetadataOperator)version.getMetadata(), Set.of(FINALIZER))) {
                    this.deleteRelatedExtensions((ProjectVersion)((Object)version));
                    this.client.update((Extension)version);
                }
                return;
            }
            ExtensionUtil.addFinalizers((MetadataOperator)version.getMetadata(), Set.of(FINALIZER));
            ProjectVersionReconciler.updateLabels(version);
            this.copyKeyAnnotationsFromParentVersion(version.getSpec().getParentVersion(), (ProjectVersion)((Object)version));
            Map annotations = MetadataUtil.nullSafeAnnotations((AbstractExtension)version);
            if ("true".equals(annotations.get("doc.halo.run/copy-from-pre-version"))) {
                this.copyDocTreeFromPreVersion(version.getMetadata().getName(), version.getSpec().getParentVersion());
                annotations.remove("doc.halo.run/copy-from-pre-version");
            }
            if (version.getMetadata().getName().equals(version.getSpec().getParentVersion())) {
                version.getSpec().setParentVersion(null);
            }
            version.getStatus().setReadiness(true);
            this.generateAndSetPermalink((ProjectVersion)((Object)version));
            this.triageDocTreeChanges((ProjectVersion)((Object)version));
            this.client.update((Extension)version);
        });
        return Reconciler.Result.doNotRetry();
    }

    void copyKeyAnnotationsFromParentVersion(String parentVersionName, ProjectVersion version) {
        if (StringUtils.isBlank((CharSequence)parentVersionName)) {
            return;
        }
        this.client.fetch(ProjectVersion.class, parentVersionName).ifPresent(parentVersion -> {
            Map parentAnnotations = MetadataUtil.nullSafeAnnotations((AbstractExtension)parentVersion);
            Map annotations = MetadataUtil.nullSafeAnnotations((AbstractExtension)version);
            annotations.put("doc.halo.run/preferred-language", (String)parentAnnotations.get("doc.halo.run/preferred-language"));
            annotations.put("doc.halo.run/preferred-version", (String)parentAnnotations.get("doc.halo.run/preferred-version"));
            annotations.put("doc.halo.run/project-slug", (String)parentAnnotations.get("doc.halo.run/project-slug"));
        });
    }

    void triageDocTreeChanges(ProjectVersion version) {
        List docTrees = this.docTreeLister.listByVersion(version.getMetadata().getName()).collectList().blockOptional().orElse(List.of());
        for (DocTree docTree : docTrees) {
            Map annotations = MetadataUtil.nullSafeAnnotations((AbstractExtension)docTree);
            annotations.put("doc.halo.run/last-config-update", Instant.now().toString());
            this.updateDocTreeWithRetry(docTree);
        }
    }

    private void updateDocTreeWithRetry(DocTree docTree) {
        try {
            this.client.update((Extension)docTree);
        }
        catch (OptimisticLockingFailureException e) {
            this.retryTemplate.execute(retryCallback -> {
                this.client.fetch(DocTree.class, docTree.getMetadata().getName()).ifPresent(latest -> {
                    docTree.getMetadata().setVersion(latest.getMetadata().getVersion());
                    this.client.update((Extension)docTree);
                });
                return null;
            });
        }
    }

    void deleteRelatedExtensions(ProjectVersion version) {
        String versionName = version.getMetadata().getName();
        List docTrees = this.docTreeLister.listByVersion(versionName).collectList().blockOptional().orElse(List.of());
        docTrees.forEach(this::deleteWithRetry);
    }

    void generateAndSetPermalink(ProjectVersion version) {
        String versionName = version.getMetadata().getName();
        this.client.fetch(Project.class, version.getSpec().getProjectName()).ifPresent(project -> {
            String projectSlug = project.getSpec().getSlug();
            Map labels = MetadataUtil.nullSafeLabels((AbstractExtension)version);
            Project.VersionRef versionRef = project.getSpec().getPreferredVersionRef();
            if (versionRef != null && versionName.equals(versionRef.getName())) {
                labels.put("doc.halo.run/marked-as-preferred", "true");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>(2, 1.0f);
            uriVariables.put("projectSlug", projectSlug);
            if (!"true".equals(labels.get("doc.halo.run/marked-as-preferred"))) {
                uriVariables.put("versionSlug", version.getSpec().getSlug());
            }
            String permalink = DocTreeUtils.buildRoutePathWithGivenVariables(uriVariables);
            version.getStatus().setPermalink(permalink);
        });
    }

    void copyDocTreeFromPreVersion(String versionName, String parentVersion) {
        DocAndTrees treeAndDocs = this.copyTreeAndDocs(versionName, parentVersion);
        List<DocTree> docTrees = treeAndDocs.docTrees();
        List<Doc> docs = treeAndDocs.docs();
        List<Snapshot> snapshots = treeAndDocs.snapshots();
        ArrayList<DocTree> createdDocTrees = new ArrayList<DocTree>();
        ArrayList<Doc> createdDocs = new ArrayList<Doc>();
        ArrayList<Snapshot> createdSnapshots = new ArrayList<Snapshot>();
        try {
            for (DocTree docTree : docTrees) {
                this.client.create((Extension)docTree);
                createdDocTrees.add(docTree);
            }
            for (Doc doc : docs) {
                this.client.create((Extension)doc);
                createdDocs.add(doc);
            }
            for (Snapshot snapshot : snapshots) {
                this.client.create((Extension)snapshot);
                createdSnapshots.add(snapshot);
            }
        }
        catch (Throwable e) {
            createdDocTrees.forEach(this::deleteWithRetry);
            createdDocs.forEach(this::deleteWithRetry);
            createdSnapshots.forEach(this::deleteWithRetry);
            throw e;
        }
        finally {
            createdDocTrees.clear();
            createdDocs.clear();
            createdSnapshots.clear();
        }
    }

    void deleteWithRetry(Extension extension) {
        try {
            this.client.delete(extension);
        }
        catch (OptimisticLockingFailureException e) {
            this.retryTemplate.execute(retryCallback -> {
                this.client.delete(extension);
                return null;
            });
        }
    }

    DocAndTrees copyTreeAndDocs(String currentVersionName, String parentVersion) {
        if (StringUtils.isBlank((CharSequence)parentVersion)) {
            return DocAndTrees.empty();
        }
        List existingDocTrees = (List)this.docTreeLister.listByVersion(parentVersion).collectList().block();
        if (CollectionUtils.isEmpty((Collection)existingDocTrees)) {
            return DocAndTrees.empty();
        }
        List<DocTree> copiedDocTrees = DocTreeUtils.copyDocTreeList(currentVersionName, existingDocTrees);
        List<Doc> copiedDocs = this.copyDocsByTree(copiedDocTrees);
        ArrayList<Snapshot> snapshotToCreate = new ArrayList<Snapshot>();
        for (Doc copiedDoc : copiedDocs) {
            String releasedSnapshot = copiedDoc.getSpec().getReleaseSnapshot();
            String headSnapshot = copiedDoc.getSpec().getHeadSnapshot();
            Ref newDocRef = Ref.of((Extension)copiedDoc);
            this.copySnapshotByName(headSnapshot, newDocRef).ifPresent(newSnapshot -> {
                copiedDoc.getSpec().setHeadSnapshot(newSnapshot.getMetadata().getName());
                snapshotToCreate.add((Snapshot)newSnapshot);
            });
            if (!StringUtils.equals((CharSequence)releasedSnapshot, (CharSequence)headSnapshot)) {
                this.copySnapshotByName(releasedSnapshot, newDocRef).ifPresent(newSnapshot -> {
                    copiedDoc.getSpec().setReleaseSnapshot(newSnapshot.getMetadata().getName());
                    snapshotToCreate.add((Snapshot)newSnapshot);
                });
                continue;
            }
            copiedDoc.getSpec().setReleaseSnapshot(copiedDoc.getSpec().getHeadSnapshot());
        }
        return new DocAndTrees(copiedDocTrees, copiedDocs, snapshotToCreate);
    }

    Optional<Snapshot> copySnapshotByName(String snapshotName, Ref docRef) {
        if (StringUtils.isBlank((CharSequence)snapshotName)) {
            return Optional.empty();
        }
        return this.client.fetch(Snapshot.class, snapshotName).map(snapshot -> {
            Snapshot newSnapshot = (Snapshot)JsonUtils.deepCopy((Object)snapshot);
            newSnapshot.getMetadata().setName(UUID.randomUUID().toString());
            newSnapshot.getSpec().setSubjectRef(docRef);
            return newSnapshot;
        });
    }

    private List<Doc> copyDocsByTree(List<DocTree> copiedDocTrees) {
        HashMap<String, String> docNameDocTreeNameMap = new HashMap<String, String>();
        ArrayList<String> docNames = new ArrayList<String>();
        for (DocTree copiedDocTree : copiedDocTrees) {
            if (!DocTree.Type.DOC.equals((Object)copiedDocTree.getSpec().getType())) continue;
            String docName = copiedDocTree.getSpec().getDocName();
            docNames.add(docName);
            docNameDocTreeNameMap.put(docName, copiedDocTree.getMetadata().getName());
        }
        Map treeNameDocTreeMap = copiedDocTrees.stream().collect(HashMap::new, (map, docTree) -> {
            if (DocTree.Type.DOC.equals((Object)docTree.getSpec().getType())) {
                map.put(docTree.getMetadata().getName(), docTree);
            }
        }, HashMap::putAll);
        ListOptions listOptions = new ListOptions();
        listOptions.setFieldSelector(FieldSelector.of((Query)QueryFactory.in((String)"metadata.name", docNames)));
        return this.client.listAll(Doc.class, listOptions, Sort.unsorted()).stream().map(existingDoc -> {
            String oldDocName = existingDoc.getMetadata().getName();
            Doc newDoc = ProjectVersionReconciler.copyDoc(existingDoc);
            String docTreeName = (String)docNameDocTreeNameMap.get(oldDocName);
            newDoc.getSpec().setDocTreeName(docTreeName);
            DocTree docTree = (DocTree)((Object)((Object)treeNameDocTreeMap.get(docTreeName)));
            docTree.getSpec().setDocName(newDoc.getMetadata().getName());
            return newDoc;
        }).toList();
    }

    public Controller setupWith(ControllerBuilder builder) {
        return builder.extension((Extension)new ProjectVersion()).build();
    }

    @Generated
    public ProjectVersionReconciler(ExtensionClient client, DocTreeLister docTreeLister) {
        this.client = client;
        this.docTreeLister = docTreeLister;
    }

    record DocAndTrees(List<DocTree> docTrees, List<Doc> docs, List<Snapshot> snapshots) {
        public static DocAndTrees empty() {
            return new DocAndTrees(List.of(), List.of(), List.of());
        }
    }
}

