/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.model;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.lang.Nullable;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.model.DocTreeNode;
import run.halo.doc.model.DocWithContent;
import run.halo.doc.model.Language;
import run.halo.doc.model.Link;
import run.halo.doc.model.LinkNavigation;
import run.halo.doc.utils.NaryTreeWalker;

public class DocTreeDetail {
    @Nullable
    private DocWithContent docInfo;
    private DocTree docTree;
    private Project project;
    private Language currentLanguage;
    private ProjectVersion currentVersion;
    private List<ProjectVersion> versions;
    private List<DocTreeNode> docTrees;
    private List<Language> languages;

    public boolean isDoc() {
        return DocTree.isDoc(this.docTree);
    }

    public boolean isTree() {
        return !this.isDoc();
    }

    public List<DocTreeNode> getCrumbs() {
        if (this.docTree == null || this.docTrees == null) {
            return List.of();
        }
        DocTreeNode targetNode = new DocTreeNode().setMetadata(this.docTree.getMetadata()).setSpec(this.docTree.getSpec()).setStatus(this.docTree.getStatus());
        NaryTreeWalker<DocTreeNode> naryTreeWalker = new NaryTreeWalker<DocTreeNode>(this.docTrees);
        return naryTreeWalker.computeNodePath(targetNode);
    }

    public List<DocTreeNode> getSonNodes() {
        if (this.docTree == null || this.docTrees == null) {
            return List.of();
        }
        String targetNodeName = this.docTree.getMetadata().getName();
        NaryTreeWalker<DocTreeNode> naryTreeWalker = new NaryTreeWalker<DocTreeNode>(this.docTrees);
        List<DocTreeNode> sonNodes = naryTreeWalker.findChildren(targetNodeName);
        sonNodes.forEach(node -> node.getChildren().clear());
        return sonNodes;
    }

    public LinkNavigation getLinkNavigation() {
        String targetNodeName = this.docTree.getMetadata().getName();
        List<DocTreeNode> dfsResult = NaryTreeWalker.dfs(this.docTrees);
        return this.findLinkNav(dfsResult, targetNodeName);
    }

    private LinkNavigation findLinkNav(List<DocTreeNode> list, String target) {
        if (list == null || target == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            DocTreeNode item = list.get(i);
            if (!target.equals(item.getName())) continue;
            Link prevLink = i > 0 ? (Link)Optional.of(list.get(i - 1)).map(node -> new Link(node.getSpec().getTitle(), node.getStatus().getPermalink())).orElse(null) : null;
            Link nextLink = i < list.size() - 1 ? (Link)Optional.of(list.get(i + 1)).map(node -> new Link(node.getSpec().getTitle(), node.getStatus().getPermalink())).orElse(null) : null;
            return new LinkNavigation(prevLink, nextLink);
        }
        return null;
    }

    @Generated
    public DocTreeDetail() {
    }

    @Nullable
    @Generated
    public DocWithContent getDocInfo() {
        return this.docInfo;
    }

    @Generated
    public DocTree getDocTree() {
        return this.docTree;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public Language getCurrentLanguage() {
        return this.currentLanguage;
    }

    @Generated
    public ProjectVersion getCurrentVersion() {
        return this.currentVersion;
    }

    @Generated
    public List<ProjectVersion> getVersions() {
        return this.versions;
    }

    @Generated
    public List<DocTreeNode> getDocTrees() {
        return this.docTrees;
    }

    @Generated
    public List<Language> getLanguages() {
        return this.languages;
    }

    @Generated
    public DocTreeDetail setDocInfo(@Nullable DocWithContent docInfo) {
        this.docInfo = docInfo;
        return this;
    }

    @Generated
    public DocTreeDetail setDocTree(DocTree docTree) {
        this.docTree = docTree;
        return this;
    }

    @Generated
    public DocTreeDetail setProject(Project project) {
        this.project = project;
        return this;
    }

    @Generated
    public DocTreeDetail setCurrentLanguage(Language currentLanguage) {
        this.currentLanguage = currentLanguage;
        return this;
    }

    @Generated
    public DocTreeDetail setCurrentVersion(ProjectVersion currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    @Generated
    public DocTreeDetail setVersions(List<ProjectVersion> versions) {
        this.versions = versions;
        return this;
    }

    @Generated
    public DocTreeDetail setDocTrees(List<DocTreeNode> docTrees) {
        this.docTrees = docTrees;
        return this;
    }

    @Generated
    public DocTreeDetail setLanguages(List<Language> languages) {
        this.languages = languages;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocTreeDetail)) {
            return false;
        }
        DocTreeDetail other = (DocTreeDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DocWithContent this$docInfo = this.getDocInfo();
        DocWithContent other$docInfo = other.getDocInfo();
        if (this$docInfo == null ? other$docInfo != null : !((Object)this$docInfo).equals(other$docInfo)) {
            return false;
        }
        DocTree this$docTree = this.getDocTree();
        DocTree other$docTree = other.getDocTree();
        if (this$docTree == null ? other$docTree != null : !((Object)((Object)this$docTree)).equals((Object)other$docTree)) {
            return false;
        }
        Project this$project = this.getProject();
        Project other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)((Object)this$project)).equals((Object)other$project)) {
            return false;
        }
        Language this$currentLanguage = this.getCurrentLanguage();
        Language other$currentLanguage = other.getCurrentLanguage();
        if (this$currentLanguage == null ? other$currentLanguage != null : !((Object)this$currentLanguage).equals(other$currentLanguage)) {
            return false;
        }
        ProjectVersion this$currentVersion = this.getCurrentVersion();
        ProjectVersion other$currentVersion = other.getCurrentVersion();
        if (this$currentVersion == null ? other$currentVersion != null : !((Object)((Object)this$currentVersion)).equals((Object)other$currentVersion)) {
            return false;
        }
        List<ProjectVersion> this$versions = this.getVersions();
        List<ProjectVersion> other$versions = other.getVersions();
        if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
            return false;
        }
        List<DocTreeNode> this$docTrees = this.getDocTrees();
        List<DocTreeNode> other$docTrees = other.getDocTrees();
        if (this$docTrees == null ? other$docTrees != null : !((Object)this$docTrees).equals(other$docTrees)) {
            return false;
        }
        List<Language> this$languages = this.getLanguages();
        List<Language> other$languages = other.getLanguages();
        return !(this$languages == null ? other$languages != null : !((Object)this$languages).equals(other$languages));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocTreeDetail;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DocWithContent $docInfo = this.getDocInfo();
        result = result * 59 + ($docInfo == null ? 43 : ((Object)$docInfo).hashCode());
        DocTree $docTree = this.getDocTree();
        result = result * 59 + ($docTree == null ? 43 : ((Object)((Object)$docTree)).hashCode());
        Project $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)((Object)$project)).hashCode());
        Language $currentLanguage = this.getCurrentLanguage();
        result = result * 59 + ($currentLanguage == null ? 43 : ((Object)$currentLanguage).hashCode());
        ProjectVersion $currentVersion = this.getCurrentVersion();
        result = result * 59 + ($currentVersion == null ? 43 : ((Object)((Object)$currentVersion)).hashCode());
        List<ProjectVersion> $versions = this.getVersions();
        result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
        List<DocTreeNode> $docTrees = this.getDocTrees();
        result = result * 59 + ($docTrees == null ? 43 : ((Object)$docTrees).hashCode());
        List<Language> $languages = this.getLanguages();
        result = result * 59 + ($languages == null ? 43 : ((Object)$languages).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocTreeDetail(docInfo=" + String.valueOf(this.getDocInfo()) + ", docTree=" + String.valueOf((Object)this.getDocTree()) + ", project=" + String.valueOf((Object)this.getProject()) + ", currentLanguage=" + String.valueOf(this.getCurrentLanguage()) + ", currentVersion=" + String.valueOf((Object)this.getCurrentVersion()) + ", versions=" + String.valueOf(this.getVersions()) + ", docTrees=" + String.valueOf(this.getDocTrees()) + ", languages=" + String.valueOf(this.getLanguages()) + ")";
    }
}

