/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.infra.search;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import run.halo.app.search.HaloDocument;
import run.halo.doc.extensions.Doc;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.infra.NotFoundException;
import run.halo.doc.model.Content;
import run.halo.doc.model.DocWithContent;
import run.halo.doc.model.Language;
import run.halo.doc.service.DocTreeService;

@Component
public class DocumentConverter
implements Converter<Doc, Mono<HaloDocument>> {
    public static final String DOCUMENT_TYPE = "doc.halo.run";
    private final DocTreeService docTreeService;

    @NonNull
    public Mono<HaloDocument> convert(@NonNull Doc doc) {
        HaloDocument haloDoc = new HaloDocument();
        haloDoc.setId(this.haloDocId(doc));
        haloDoc.setMetadataName(doc.getMetadata().getName());
        haloDoc.setType(DOCUMENT_TYPE);
        haloDoc.setExposed(this.isExposed(doc));
        haloDoc.setRecycled(false);
        haloDoc.setOwnerName(doc.getSpec().getOwner());
        haloDoc.setUpdateTimestamp(doc.getSpec().getPublishedAt());
        haloDoc.setCreationTimestamp(doc.getMetadata().getCreationTimestamp());
        haloDoc.setPublished(Doc.isPublished(doc));
        return this.docTreeService.getByName(doc.getSpec().getDocTreeName(), false).doOnNext(docTreeDetail -> {
            DocWithContent docInfo = docTreeDetail.getDocInfo();
            if (docInfo == null) {
                throw new NotFoundException("Doc not found: " + doc.getMetadata().getName());
            }
            DocTree docTree = docTreeDetail.getDocTree();
            haloDoc.setTitle(docTree.getSpec().getTitle());
            haloDoc.setPermalink(docTree.getStatus().getPermalink());
            String content = Optional.ofNullable(docInfo.getContent()).map(Content::content).filter(StringUtils::isNotBlank).orElseGet(() -> docTree.getSpec().getTitle());
            haloDoc.setContent(content);
            haloDoc.setDescription(content);
            ProjectVersion version = docTreeDetail.getCurrentVersion();
            String versionName = version.getMetadata().getName();
            String projectName = version.getSpec().getProjectName();
            Language currentLang = docTreeDetail.getCurrentLanguage();
            String lang = currentLang == null ? "default" : currentLang.getLanguage();
            haloDoc.setCategories(List.of(this.projectCategory(projectName), this.versionCategory(versionName), this.langCategory(lang)));
        }).thenReturn((Object)haloDoc);
    }

    String projectCategory(String projectName) {
        return "project:" + projectName;
    }

    String versionCategory(String versionName) {
        return "version:" + versionName;
    }

    String langCategory(String lang) {
        return "lang:" + lang;
    }

    boolean isExposed(Doc doc) {
        return Doc.isPublished(doc);
    }

    String haloDocId(Doc doc) {
        return "doc.halo.run-" + doc.getMetadata().getName();
    }

    @Generated
    public DocumentConverter(DocTreeService docTreeService) {
        this.docTreeService = docTreeService;
    }
}

