/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.infra.search;

import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionClient;
import run.halo.app.extension.ExtensionOperator;
import run.halo.app.extension.ExtensionUtil;
import run.halo.app.extension.MetadataOperator;
import run.halo.app.extension.controller.Controller;
import run.halo.app.extension.controller.ControllerBuilder;
import run.halo.app.extension.controller.Reconciler;
import run.halo.app.search.HaloDocument;
import run.halo.app.search.event.HaloDocumentAddRequestEvent;
import run.halo.app.search.event.HaloDocumentDeleteRequestEvent;
import run.halo.doc.extensions.Doc;
import run.halo.doc.infra.search.DocumentConverter;

@Component
public class DocLuceneIndexReconciler
implements Reconciler<Reconciler.Request> {
    static final String FINALIZER = "manage-lucene-index";
    private final ExtensionClient client;
    private final ApplicationEventPublisher eventPublisher;
    private final DocumentConverter converter;

    public Reconciler.Result reconcile(Reconciler.Request request) {
        this.client.fetch(Doc.class, request.name()).ifPresent(doc -> {
            if (ExtensionUtil.isDeleted((ExtensionOperator)doc)) {
                if (ExtensionUtil.removeFinalizers((MetadataOperator)doc.getMetadata(), Set.of(FINALIZER))) {
                    this.eventPublisher.publishEvent((ApplicationEvent)new HaloDocumentDeleteRequestEvent((Object)this, List.of(this.converter.haloDocId((Doc)((Object)doc)))));
                    this.client.update((Extension)doc);
                }
                return;
            }
            ExtensionUtil.addFinalizers((MetadataOperator)doc.getMetadata(), Set.of(FINALIZER));
            HaloDocument haloDoc = (HaloDocument)this.converter.convert((Doc)((Object)doc)).blockOptional().orElseThrow();
            this.eventPublisher.publishEvent((ApplicationEvent)new HaloDocumentAddRequestEvent((Object)this, List.of(haloDoc)));
            this.client.update((Extension)doc);
        });
        return Reconciler.Result.doNotRetry();
    }

    public Controller setupWith(ControllerBuilder builder) {
        return builder.extension((Extension)new Doc()).workerCount(1).build();
    }

    @Generated
    public DocLuceneIndexReconciler(ExtensionClient client, ApplicationEventPublisher eventPublisher, DocumentConverter converter) {
        this.client = client;
        this.eventPublisher = eventPublisher;
        this.converter = converter;
    }
}

