/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.infra.flexmark.admonitions;

import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.springframework.lang.NonNull;
import run.halo.doc.infra.flexmark.admonitions.AdmonitionBlock;

public class AdmonitionBlockParser
extends AbstractBlockParser {
    private static final Pattern REGEX_BEGIN = Pattern.compile("^:::(\\w+)(?:\\s+(.*?))?$");
    private static final Pattern REGEX_END = Pattern.compile("^:::$");
    private final AdmonitionBlock block;
    private boolean properlyClosed = false;

    public AdmonitionBlockParser(BasedSequence type, BasedSequence title) {
        this.block = new AdmonitionBlock(type, title);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        BasedSequence line = state.getLine();
        if (REGEX_END.matcher(line).find()) {
            this.properlyClosed = true;
            return BlockContinue.finished();
        }
        return BlockContinue.atIndex(state.getIndex());
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return !this.properlyClosed;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public void closeBlock(ParserState state) {
        if (!this.properlyClosed) {
            return;
        }
        this.block.setCharsFromContent();
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @NonNull
        public BlockParserFactory apply(@NonNull DataHolder options) {
            return new AbstractBlockParserFactory(options){

                @Override
                public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
                    BasedSequence line = state.getLine();
                    Matcher m = REGEX_BEGIN.matcher(line);
                    if (m.find()) {
                        BasedSequence type = BasedSequence.of(m.group(1));
                        if (AdmonitionBlock.isInValidType(type)) {
                            return BlockStart.none();
                        }
                        BasedSequence title = m.groupCount() > 1 && m.group(2) != null ? line.subSequence(m.start(2), m.end(2)) : BasedSequence.NULL;
                        AdmonitionBlockParser blockParser = new AdmonitionBlockParser(type, title);
                        return BlockStart.of(blockParser).atIndex(line.length());
                    }
                    return BlockStart.none();
                }
            };
        }

        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

