/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.infra;

import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ListOptions;
import run.halo.app.extension.ListResult;
import run.halo.app.extension.PageRequest;
import run.halo.app.extension.PageRequestImpl;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.index.query.QueryFactory;
import run.halo.app.extension.router.selector.FieldSelector;
import run.halo.doc.infra.ReactiveExtensionPaginatedOperator;

@Component
public class ReactiveExtensionPaginatedOperatorImpl
implements ReactiveExtensionPaginatedOperator {
    private static final int DEFAULT_PAGE_SIZE = 200;
    private final ReactiveExtensionClient client;

    static <E extends Extension> boolean shouldTakeNext(E item, Instant now) {
        Instant creationTimestamp = item.getMetadata().getCreationTimestamp();
        return creationTimestamp.isBefore(now) || creationTimestamp.equals(now);
    }

    static <E extends Extension> PageRequest nextPage(ListResult<E> result, Sort sort) {
        return PageRequestImpl.of((int)(result.getPage() + 1), (int)result.getSize(), (Sort)sort);
    }

    @Override
    public <E extends Extension> Mono<Void> deleteContinuously(Class<E> type, ListOptions listOptions) {
        PageRequest pageRequest = this.createPageRequest();
        return this.cleanupContinuously(type, listOptions, pageRequest);
    }

    private <E extends Extension> Mono<Void> cleanupContinuously(Class<E> type, ListOptions listOptions, PageRequest pageRequest) {
        return this.pageBy(type, listOptions, pageRequest).flatMap(page -> Flux.fromIterable((Iterable)page.getItems()).flatMap(arg_0 -> ((ReactiveExtensionClient)this.client).delete(arg_0)).then((Mono)(page.hasNext() ? this.cleanupContinuously(type, listOptions, pageRequest) : Mono.empty())));
    }

    @Override
    public <E extends Extension> Flux<E> deleteInitialBatch(Class<E> type, ListOptions listOptions) {
        PageRequest pageRequest = this.createPageRequest();
        FieldSelector newFieldQuery = listOptions.getFieldSelector().andQuery(QueryFactory.isNull((String)"metadata.deletionTimestamp"));
        listOptions.setFieldSelector(newFieldQuery);
        Instant now = Instant.now();
        return this.pageBy(type, listOptions, pageRequest).expand(result -> result.hasNext() ? this.pageBy(type, listOptions, pageRequest) : Mono.empty()).flatMap(result -> Flux.fromIterable((Iterable)result.getItems())).takeWhile(item -> ReactiveExtensionPaginatedOperatorImpl.shouldTakeNext(item, now)).flatMap(this::deleteWithRetry);
    }

    <E extends Extension> Mono<E> deleteWithRetry(E item) {
        return this.client.delete(item).onErrorResume(OptimisticLockingFailureException.class, e -> this.attemptToDelete(item.getClass(), item.getMetadata().getName()));
    }

    private <E extends Extension> Mono<E> attemptToDelete(Class<E> type, String name) {
        return Mono.defer(() -> this.client.fetch(type, name).flatMap(arg_0 -> ((ReactiveExtensionClient)this.client).delete(arg_0))).retryWhen((Retry)Retry.backoff((long)8L, (Duration)Duration.ofMillis(100L)).filter(OptimisticLockingFailureException.class::isInstance));
    }

    @Override
    public <E extends Extension> Flux<E> list(Class<E> type, ListOptions listOptions) {
        PageRequest pageRequest = this.createPageRequest();
        return this.list(type, listOptions, pageRequest);
    }

    private <E extends Extension> Flux<E> list(Class<E> type, ListOptions listOptions, PageRequest pageRequest) {
        Instant now = Instant.now();
        return this.pageBy(type, listOptions, pageRequest).expand(result -> {
            if (result.hasNext()) {
                PageRequest nextPage = ReactiveExtensionPaginatedOperatorImpl.nextPage(result, pageRequest.getSort());
                return this.pageBy(type, listOptions, nextPage);
            }
            return Mono.empty();
        }).flatMap(page -> Flux.fromIterable((Iterable)page.getItems())).takeWhile(item -> ReactiveExtensionPaginatedOperatorImpl.shouldTakeNext(item, now));
    }

    private PageRequest createPageRequest() {
        return PageRequestImpl.of((int)1, (int)200, (Sort)Sort.by((String[])new String[]{"metadata.creationTimestamp", "metadata.name"}));
    }

    private <E extends Extension> Mono<ListResult<E>> pageBy(Class<E> type, ListOptions listOptions, PageRequest pageRequest) {
        return this.client.listBy(type, listOptions, pageRequest);
    }

    @Generated
    public ReactiveExtensionPaginatedOperatorImpl(ReactiveExtensionClient client) {
        this.client = client;
    }
}

