/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.extensions;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.lang.NonNull;
import run.halo.app.extension.AbstractExtension;
import run.halo.app.extension.GVK;
import run.halo.app.infra.ConditionList;

@GVK(group="doc.halo.run", version="v1alpha1", kind="DocTree", plural="doctrees", singular="doctree")
public class DocTree
extends AbstractExtension {
    public static final String MARKED_AS_LANGUAGE_LABEL = "doc.halo.run/marked-as-language";
    public static final String PROJECT_CONFIG_CHANGED = "doc.halo.run/last-config-update";
    public static final String TREE_NODE_PATH = "doc.halo.run/tree-node-path";
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private Spec spec;
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private Status status;

    public static boolean isDoc(DocTree docTree) {
        return Type.DOC.equals((Object)docTree.getSpec().getType());
    }

    public static boolean isPublished(DocTree docTree) {
        if (Type.DOC.equals((Object)docTree.getSpec().getType())) {
            return BooleanUtils.isTrue((Boolean)docTree.getStatus().getPublished());
        }
        return true;
    }

    @NonNull
    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    @Generated
    public DocTree() {
    }

    @Generated
    public Spec getSpec() {
        return this.spec;
    }

    @Generated
    public void setSpec(Spec spec) {
        this.spec = spec;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public String toString() {
        return "DocTree(spec=" + String.valueOf(this.getSpec()) + ", status=" + String.valueOf(this.getStatus()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocTree)) {
            return false;
        }
        DocTree other = (DocTree)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spec this$spec = this.getSpec();
        Spec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)this$status).equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocTree;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Spec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        return result;
    }

    @Schema(name="DocTreeType")
    public static enum Type {
        TREE,
        DOC;

    }

    @Schema(name="DocTreeSpec")
    public static class Spec {
        @Schema(requiredMode=Schema.RequiredMode.REQUIRED, minLength=1)
        private String title;
        private String description = "";
        @Schema(requiredMode=Schema.RequiredMode.REQUIRED, minLength=1)
        private String slug;
        @Schema(requiredMode=Schema.RequiredMode.REQUIRED, minLength=1)
        private String projectVersionName;
        @Schema(requiredMode=Schema.RequiredMode.REQUIRED, minLength=1)
        private Type type;
        @Schema(description="Reference to the doc name.")
        private String docName;
        private int priority;
        @Schema(description="The parent doc tree name.")
        private String parent;

        @Generated
        public Spec() {
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getSlug() {
            return this.slug;
        }

        @Generated
        public String getProjectVersionName() {
            return this.projectVersionName;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public String getDocName() {
            return this.docName;
        }

        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Generated
        public String getParent() {
            return this.parent;
        }

        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setSlug(String slug) {
            this.slug = slug;
        }

        @Generated
        public void setProjectVersionName(String projectVersionName) {
            this.projectVersionName = projectVersionName;
        }

        @Generated
        public void setType(Type type) {
            this.type = type;
        }

        @Generated
        public void setDocName(String docName) {
            this.docName = docName;
        }

        @Generated
        public void setPriority(int priority) {
            this.priority = priority;
        }

        @Generated
        public void setParent(String parent) {
            this.parent = parent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Spec)) {
                return false;
            }
            Spec other = (Spec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPriority() != other.getPriority()) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$slug = this.getSlug();
            String other$slug = other.getSlug();
            if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
                return false;
            }
            String this$projectVersionName = this.getProjectVersionName();
            String other$projectVersionName = other.getProjectVersionName();
            if (this$projectVersionName == null ? other$projectVersionName != null : !this$projectVersionName.equals(other$projectVersionName)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$docName = this.getDocName();
            String other$docName = other.getDocName();
            if (this$docName == null ? other$docName != null : !this$docName.equals(other$docName)) {
                return false;
            }
            String this$parent = this.getParent();
            String other$parent = other.getParent();
            return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Spec;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPriority();
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $slug = this.getSlug();
            result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
            String $projectVersionName = this.getProjectVersionName();
            result = result * 59 + ($projectVersionName == null ? 43 : $projectVersionName.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $docName = this.getDocName();
            result = result * 59 + ($docName == null ? 43 : $docName.hashCode());
            String $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DocTree.Spec(title=" + this.getTitle() + ", description=" + this.getDescription() + ", slug=" + this.getSlug() + ", projectVersionName=" + this.getProjectVersionName() + ", type=" + String.valueOf((Object)this.getType()) + ", docName=" + this.getDocName() + ", priority=" + this.getPriority() + ", parent=" + this.getParent() + ")";
        }
    }

    @Schema(name="DocTreeStatus")
    public static class Status {
        private String permalink;
        private long observedVersion;
        private boolean inProgress;
        private Boolean published;
        private ConditionList conditions = new ConditionList();

        @Generated
        public Status() {
        }

        @Generated
        public String getPermalink() {
            return this.permalink;
        }

        @Generated
        public long getObservedVersion() {
            return this.observedVersion;
        }

        @Generated
        public boolean isInProgress() {
            return this.inProgress;
        }

        @Generated
        public Boolean getPublished() {
            return this.published;
        }

        @Generated
        public ConditionList getConditions() {
            return this.conditions;
        }

        @Generated
        public void setPermalink(String permalink) {
            this.permalink = permalink;
        }

        @Generated
        public void setObservedVersion(long observedVersion) {
            this.observedVersion = observedVersion;
        }

        @Generated
        public void setInProgress(boolean inProgress) {
            this.inProgress = inProgress;
        }

        @Generated
        public void setPublished(Boolean published) {
            this.published = published;
        }

        @Generated
        public void setConditions(ConditionList conditions) {
            this.conditions = conditions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status other = (Status)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getObservedVersion() != other.getObservedVersion()) {
                return false;
            }
            if (this.isInProgress() != other.isInProgress()) {
                return false;
            }
            Boolean this$published = this.getPublished();
            Boolean other$published = other.getPublished();
            if (this$published == null ? other$published != null : !((Object)this$published).equals(other$published)) {
                return false;
            }
            String this$permalink = this.getPermalink();
            String other$permalink = other.getPermalink();
            if (this$permalink == null ? other$permalink != null : !this$permalink.equals(other$permalink)) {
                return false;
            }
            ConditionList this$conditions = this.getConditions();
            ConditionList other$conditions = other.getConditions();
            return !(this$conditions == null ? other$conditions != null : !this$conditions.equals(other$conditions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Status;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $observedVersion = this.getObservedVersion();
            result = result * 59 + (int)($observedVersion >>> 32 ^ $observedVersion);
            result = result * 59 + (this.isInProgress() ? 79 : 97);
            Boolean $published = this.getPublished();
            result = result * 59 + ($published == null ? 43 : ((Object)$published).hashCode());
            String $permalink = this.getPermalink();
            result = result * 59 + ($permalink == null ? 43 : $permalink.hashCode());
            ConditionList $conditions = this.getConditions();
            result = result * 59 + ($conditions == null ? 43 : $conditions.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DocTree.Status(permalink=" + this.getPermalink() + ", observedVersion=" + this.getObservedVersion() + ", inProgress=" + this.isInProgress() + ", published=" + this.getPublished() + ", conditions=" + String.valueOf(this.getConditions()) + ")";
        }
    }

    public static enum ConditionType {
        SUCCESS,
        INVALID,
        FAILURE;

    }
}

