/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc.endpoint;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import lombok.Generated;
import org.springdoc.core.fn.builders.apiresponse.Builder;
import org.springdoc.webflux.core.fn.SpringdocRouteBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;
import run.halo.app.core.extension.content.Snapshot;
import run.halo.app.core.extension.endpoint.CustomEndpoint;
import run.halo.app.extension.Extension;
import run.halo.app.extension.GroupVersion;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.doc.extensions.Doc;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;
import run.halo.doc.model.Content;
import run.halo.doc.model.DocWithContent;
import run.halo.doc.service.DocService;
import run.halo.doc.service.ProjectPermissionService;
import run.halo.doc.utils.PrincipalUtils;

@Component
public class DocEndpoint
implements CustomEndpoint {
    private final ProjectPermissionService projectPermissionService;
    private final ReactiveExtensionClient client;
    private final DocService docService;

    public RouterFunction<ServerResponse> endpoint() {
        String tag = "api.uc.doc.halo.run/v1alpha1/Doc";
        return SpringdocRouteBuilder.route().POST("docs", this::draftDoc, builder -> builder.operationId("CreateOrUpdateDoc").description("Create or update a doc").tag("api.uc.doc.halo.run/v1alpha1/Doc").requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().implementation(DocRequest.class)).response(Builder.responseBuilder().implementation(DocWithContent.class))).PUT("docs/{name}/head-content", this::updateDocContent, builder -> builder.operationId("UpdateDocContent").description("Update doc content by doc name.").tag("api.uc.doc.halo.run/v1alpha1/Doc").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().implementation(Content.class)).response(Builder.responseBuilder().implementation(DocWithContent.class))).PUT("docs/{name}/publish", this::publishDoc, builder -> builder.operationId("PublishDoc").description("Publish a doc").tag("api.uc.doc.halo.run/v1alpha1/Doc").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementation(Doc.class))).PUT("docs/{name}/unpublish", this::unpublishDoc, builder -> builder.operationId("unpublishDoc").description("Unpublish a doc").tag("api.uc.doc.halo.run/v1alpha1/Doc").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementation(Doc.class))).GET("docs/{name}/head-content", this::getHeadContent, builder -> builder.operationId("GetHeadContent").description("Get head content by doc name.").tag("api.uc.doc.halo.run/v1alpha1/Doc").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementation(ContentResult.class))).GET("docs/{name}", this::getDoc, builder -> builder.operationId("GetDoc").description("Get doc by name.").tag("api.uc.doc.halo.run/v1alpha1/Doc").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().in(ParameterIn.PATH).name("name").required(true)).response(Builder.responseBuilder().implementation(Doc.class))).build();
    }

    private Mono<ServerResponse> unpublishDoc(ServerRequest request) {
        String docName = request.pathVariable("name");
        return this.client.get(Doc.class, docName).flatMap(doc -> this.checkWritePermission(doc.getSpec().getDocTreeName()).thenReturn((Object)doc)).flatMap(doc -> {
            doc.getSpec().setPublish(false);
            doc.getSpec().setUpdatedAt(Instant.now());
            return PrincipalUtils.currentUsername().flatMap(username -> {
                doc.getSpec().setUpdatedBy((String)username);
                return this.client.update((Extension)doc);
            });
        }).flatMap(doc -> ServerResponse.ok().bodyValue((Object)doc));
    }

    private Mono<ServerResponse> getDoc(ServerRequest request) {
        String name = request.pathVariable("name");
        return this.client.get(Doc.class, name).flatMap(doc -> this.checkReadPermission(doc.getSpec().getDocTreeName()).thenReturn((Object)doc)).flatMap(doc -> ServerResponse.ok().bodyValue((Object)doc));
    }

    private Mono<ServerResponse> updateDocContent(ServerRequest request) {
        String docName = request.pathVariable("name");
        return request.bodyToMono(Content.class).flatMap(c -> this.client.get(Doc.class, docName).map(doc -> this.checkWritePermission(doc.getSpec().getDocTreeName())).thenReturn(c)).flatMap(content -> this.docService.updateHeadContent(docName, (Content)content)).flatMap(docWithContent -> ServerResponse.ok().bodyValue(docWithContent));
    }

    private Mono<ServerResponse> publishDoc(ServerRequest request) {
        String docName = request.pathVariable("name");
        return this.client.get(Doc.class, docName).flatMap(doc -> this.checkWritePermission(doc.getSpec().getDocTreeName()).thenReturn((Object)doc)).flatMap(doc -> {
            if (doc.getSpec().getPublishedAt() == null) {
                doc.getSpec().setPublishedAt(Instant.now());
            }
            doc.getSpec().setReleaseSnapshot(doc.getSpec().getHeadSnapshot());
            doc.getSpec().setPublish(true);
            doc.getSpec().setUpdatedAt(Instant.now());
            return PrincipalUtils.currentUsername().flatMap(username -> {
                doc.getSpec().setUpdatedBy((String)username);
                return this.client.update((Extension)doc);
            });
        }).flatMap(doc -> ServerResponse.ok().bodyValue((Object)doc));
    }

    private Mono<ServerResponse> getHeadContent(ServerRequest request) {
        String docName = request.pathVariable("name");
        return this.client.get(Doc.class, docName).flatMap(doc -> this.checkReadPermission(doc.getSpec().getDocTreeName()).thenReturn((Object)doc)).flatMap(doc -> {
            String headSnapshot = doc.getSpec().getHeadSnapshot();
            return this.client.get(Snapshot.class, headSnapshot).map(snapshot -> {
                Snapshot.SnapShotSpec spec = snapshot.getSpec();
                return new ContentResult().setContent(spec.getContentPatch()).setRaw(spec.getRawPatch()).setRawType(spec.getRawType()).setName(snapshot.getMetadata().getName());
            });
        }).flatMap(result -> ServerResponse.ok().bodyValue(result));
    }

    private Mono<ServerResponse> draftDoc(ServerRequest request) {
        return request.bodyToMono(DocRequest.class).flatMap(docReq -> {
            Doc doc = docReq.getDoc();
            return this.checkWritePermission(doc.getSpec().getDocTreeName()).thenReturn(docReq);
        }).flatMap(docReq -> {
            Doc doc = docReq.getDoc();
            Content content = docReq.getContent();
            return this.docService.draftOrUpdate(doc, content);
        }).flatMap(detail -> ServerResponse.ok().bodyValue(detail));
    }

    private Mono<Void> checkWritePermission(String docTreeName) {
        return this.checkPermission(docTreeName, Project.PermissionLevel.WRITE);
    }

    private Mono<Void> checkReadPermission(String docTreeName) {
        return this.checkPermission(docTreeName, Project.PermissionLevel.READ);
    }

    private Mono<Void> checkPermission(String docTreeName, Project.PermissionLevel permissionLevel) {
        return this.getProjectBy(docTreeName).flatMap(project -> this.projectPermissionService.checkPermission((Project)((Object)project), permissionLevel));
    }

    private Mono<Project> getProjectBy(String docTreeName) {
        return this.client.fetch(DocTree.class, docTreeName).flatMap(docTree -> this.client.get(ProjectVersion.class, docTree.getSpec().getProjectVersionName()).map(version -> version.getSpec().getProjectName()).flatMap(projectName -> this.client.get(Project.class, projectName)));
    }

    public GroupVersion groupVersion() {
        return GroupVersion.parseAPIVersion((String)"api.uc.doc.halo.run/v1alpha1");
    }

    @Generated
    public DocEndpoint(ProjectPermissionService projectPermissionService, ReactiveExtensionClient client, DocService docService) {
        this.projectPermissionService = projectPermissionService;
        this.client = client;
        this.docService = docService;
    }

    static class DocRequest {
        @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
        private Doc doc;
        @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
        private Content content;

        @Generated
        public DocRequest() {
        }

        @Generated
        public Doc getDoc() {
            return this.doc;
        }

        @Generated
        public Content getContent() {
            return this.content;
        }

        @Generated
        public void setDoc(Doc doc) {
            this.doc = doc;
        }

        @Generated
        public void setContent(Content content) {
            this.content = content;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocRequest)) {
                return false;
            }
            DocRequest other = (DocRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Doc this$doc = this.getDoc();
            Doc other$doc = other.getDoc();
            if (this$doc == null ? other$doc != null : !((Object)((Object)this$doc)).equals((Object)other$doc)) {
                return false;
            }
            Content this$content = this.getContent();
            Content other$content = other.getContent();
            return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DocRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Doc $doc = this.getDoc();
            result = result * 59 + ($doc == null ? 43 : ((Object)((Object)$doc)).hashCode());
            Content $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DocEndpoint.DocRequest(doc=" + String.valueOf((Object)this.getDoc()) + ", content=" + String.valueOf(this.getContent()) + ")";
        }
    }

    static class ContentResult {
        private String name;
        private String raw;
        private String content;
        private String rawType;

        @Generated
        public ContentResult() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getRaw() {
            return this.raw;
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public String getRawType() {
            return this.rawType;
        }

        @Generated
        public ContentResult setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ContentResult setRaw(String raw) {
            this.raw = raw;
            return this;
        }

        @Generated
        public ContentResult setContent(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public ContentResult setRawType(String rawType) {
            this.rawType = rawType;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentResult)) {
                return false;
            }
            ContentResult other = (ContentResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$raw = this.getRaw();
            String other$raw = other.getRaw();
            if (this$raw == null ? other$raw != null : !this$raw.equals(other$raw)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$rawType = this.getRawType();
            String other$rawType = other.getRawType();
            return !(this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ContentResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $raw = this.getRaw();
            result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $rawType = this.getRawType();
            result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DocEndpoint.ContentResult(name=" + this.getName() + ", raw=" + this.getRaw() + ", content=" + this.getContent() + ", rawType=" + this.getRawType() + ")";
        }
    }
}

