/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc;

import java.io.IOException;
import java.nio.file.Path;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;
import run.halo.app.extension.ConfigMap;
import run.halo.app.extension.ExtensionClient;
import run.halo.app.extension.Scheme;
import run.halo.app.extension.SchemeManager;
import run.halo.app.extension.index.IndexAttributeFactory;
import run.halo.app.extension.index.IndexSpec;
import run.halo.app.plugin.BasePlugin;
import run.halo.app.plugin.PluginContext;
import run.halo.app.plugin.PluginsRootGetter;
import run.halo.doc.extensions.Doc;
import run.halo.doc.extensions.DocTree;
import run.halo.doc.extensions.Project;
import run.halo.doc.extensions.ProjectVersion;

@EnableAsync
@Component
public class HaloDocPlugin
extends BasePlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HaloDocPlugin.class);
    private final SchemeManager schemeManager;
    private final ExtensionClient client;
    private final PluginsRootGetter pluginsRootGetter;

    public HaloDocPlugin(PluginContext pluginContext, SchemeManager schemeManager, ExtensionClient client, PluginsRootGetter pluginsRootGetter) {
        super(pluginContext);
        this.schemeManager = schemeManager;
        this.client = client;
        this.pluginsRootGetter = pluginsRootGetter;
    }

    public void start() {
        this.schemeManager.register(Doc.class);
        this.schemeManager.register(DocTree.class, indexSpecs -> {
            indexSpecs.add(new IndexSpec().setName("spec.priority").setIndexFunc(IndexAttributeFactory.simpleAttribute(DocTree.class, docTree -> String.valueOf(docTree.getSpec().getPriority()))));
            indexSpecs.add(new IndexSpec().setName("spec.type").setIndexFunc(IndexAttributeFactory.simpleAttribute(DocTree.class, docTree -> docTree.getSpec().getType().name())));
            indexSpecs.add(new IndexSpec().setName("spec.projectVersionName").setIndexFunc(IndexAttributeFactory.simpleAttribute(DocTree.class, docTree -> docTree.getSpec().getProjectVersionName())));
        });
        this.schemeManager.register(Project.class, indexSpecs -> indexSpecs.add(new IndexSpec().setName("spec.slug").setUnique(true).setIndexFunc(IndexAttributeFactory.simpleAttribute(Project.class, project -> project.getSpec().getSlug()))));
        this.schemeManager.register(ProjectVersion.class, indexSpecs -> {
            indexSpecs.add(new IndexSpec().setName("spec.projectName").setIndexFunc(IndexAttributeFactory.simpleAttribute(ProjectVersion.class, projectVersion -> projectVersion.getSpec().getProjectName())));
            indexSpecs.add(new IndexSpec().setName("spec.slug").setIndexFunc(IndexAttributeFactory.simpleAttribute(ProjectVersion.class, projectVersion -> projectVersion.getSpec().getSlug())));
        });
        Path indicatesPath = ((Path)this.pluginsRootGetter.get()).resolve("plugins/caches/docsme");
        try {
            FileSystemUtils.deleteRecursively((Path)indicatesPath);
        }
        catch (IOException e) {
            log.warn("Failed to delete doc plugin cache directory: {}", (Object)indicatesPath, (Object)e);
        }
    }

    public void stop() {
        this.schemeManager.unregister(Scheme.buildFromType(Doc.class));
        this.schemeManager.unregister(Scheme.buildFromType(DocTree.class));
        this.schemeManager.unregister(Scheme.buildFromType(Project.class));
        this.schemeManager.unregister(Scheme.buildFromType(ProjectVersion.class));
    }

    public void delete() {
        this.client.fetch(ConfigMap.class, "doc-tree-route-map.docsme.halo.run").ifPresent(arg_0 -> ((ExtensionClient)this.client).delete(arg_0));
    }
}

