/*
 * Decompiled with CFR 0.152.
 */
package run.halo.doc;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.appstore.license.LicenseManager;
import run.halo.appstore.license.Licenses;

public final class CheckLicense
extends Enum<CheckLicense> {
    @Generated
    private static final Logger log;
    private static final String ROOT_CERT = "-----BEGIN CERTIFICATE-----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\nfc+jspdsZUBjYdsopgINnmGzfwzI4Oeod3woTJUjMD/K\n-----END CERTIFICATE-----";
    private static final /* synthetic */ CheckLicense[] $VALUES;

    public static CheckLicense[] values() {
        return (CheckLicense[])$VALUES.clone();
    }

    public static CheckLicense valueOf(String name) {
        return Enum.valueOf(CheckLicense.class, name);
    }

    public static boolean hasLicensed() {
        LicenseManager licenseManager = Licenses.getLicenseManager();
        if (licenseManager == null) {
            log.debug("License manager was not ready.");
            return false;
        }
        String licenseCode = licenseManager.getLicenseCode("app-yffxw").orElse(null);
        if (StringUtils.isBlank((CharSequence)licenseCode)) {
            log.debug("License token is blank");
            return false;
        }
        String[] parts = licenseCode.split("-");
        if (parts.length < 3) {
            log.error("The format of license token {} was invalid", (Object)licenseCode);
            return false;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] licenseDataBytes = decoder.decode(parts[0]);
        byte[] signatureBytes = decoder.decode(parts[1]);
        byte[] certBytes = decoder.decode(parts[2]);
        try {
            Certificate cert = CheckLicense.createCertificate(certBytes);
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(cert);
            signature.update(licenseDataBytes);
            return signature.verify(signatureBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertPathBuilderException | CertPathValidatorException | CertificateException e) {
            log.error("Failed to check license", (Throwable)e);
            return false;
        }
    }

    private static Certificate createCertificate(byte[] certBytes) throws CertificateException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, CertPathBuilderException, CertPathValidatorException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBytes));
        X509Certificate rootCert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(ROOT_CERT.getBytes(StandardCharsets.UTF_8)));
        Set<X509Certificate> allCerts = Set.of(rootCert, cert);
        TrustAnchor trustAnchor = new TrustAnchor(rootCert, null);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        trustAnchors.add(trustAnchor);
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        PKIXBuilderParameters params = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        params.setRevocationEnabled(false);
        params.setDate(cert.getNotBefore());
        params.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(allCerts)));
        CertPath certPath = CertPathBuilder.getInstance("PKIX").build(params).getCertPath();
        if (certPath != null) {
            CertPathValidator.getInstance("PKIX").validate(certPath, params);
            return cert;
        }
        throw new RuntimeException("Certificate was invalid.");
    }

    private static /* synthetic */ CheckLicense[] $values() {
        return new CheckLicense[0];
    }

    static {
        $VALUES = CheckLicense.$values();
        log = LoggerFactory.getLogger(CheckLicense.class);
    }
}

